<?php
/**
 * Centovacast
 *
 * @package blesta
 * @subpackage blesta.language.es_es
 * @copyright Copyright (c) 2024, Phillips Data, Inc.
 * @license http://www.blesta.com/license/ The Blesta License Agreement
 * @link http://www.blesta.com/ Blesta
 */

$lang['Centovacast.name'] = 'CentovaCast';
$lang['Centovacast.description'] = 'Gestione una única estación con facilidad, o automatice un negocio de alojamiento de flujos con miles de clientes. ¡Centova Cast puede manejar prácticamente cualquier escenario de alojamiento de streaming!';
$lang['Centovacast.module_row'] = 'Servidor';
$lang['Centovacast.module_row_plural'] = 'Servidores';
$lang['Centovacast.module_group'] = 'Grupo de servidores';
$lang['Centovacast.tab_stats'] = 'Estadísticas';
$lang['Centovacast.tab_actions'] = 'Acciones';
$lang['Centovacast.tab_client_stats'] = 'Estadísticas';
$lang['Centovacast.tab_client_actions'] = 'Acciones';
$lang['Centovacast.add_module_row'] = 'Añadir servidor';
$lang['Centovacast.add_module_group'] = 'Añadir grupo de servidores';
$lang['Centovacast.manage.module_rows_title'] = 'Servidores';
$lang['Centovacast.manage.module_groups_title'] = 'Grupos de servidores';
$lang['Centovacast.manage.module_rows_heading.name'] = 'Etiqueta del servidor';
$lang['Centovacast.manage.module_rows_heading.hostname'] = 'Nombre de host';
$lang['Centovacast.manage.module_rows_heading.accounts'] = 'Cuentas';
$lang['Centovacast.manage.module_rows_heading.options'] = 'Opciones';
$lang['Centovacast.manage.module_groups_heading.name'] = 'Nombre del grupo';
$lang['Centovacast.manage.module_groups_heading.servers'] = 'Recuento de servidores';
$lang['Centovacast.manage.module_groups_heading.options'] = 'Opciones';
$lang['Centovacast.manage.module_rows.count'] = '%1$s / %2$s';
$lang['Centovacast.manage.module_rows.edit'] = 'Editar';
$lang['Centovacast.manage.module_groups.edit'] = 'Editar';
$lang['Centovacast.manage.module_rows.delete'] = 'Borrar';
$lang['Centovacast.manage.module_groups.delete'] = 'Borrar';
$lang['Centovacast.manage.module_rows.confirm_delete'] = '¿Está seguro de que desea eliminar este servidor?';
$lang['Centovacast.manage.module_groups.confirm_delete'] = '¿Está seguro de que desea eliminar este grupo de servidores?';
$lang['Centovacast.manage.module_rows_no_results'] = 'No hay servidores.';
$lang['Centovacast.manage.module_groups_no_results'] = 'No hay grupos de servidores.';
$lang['Centovacast.order_options.first'] = 'Primer servidor no lleno';
$lang['Centovacast.order_options.roundrobin'] = 'Distribución uniforme entre servidores';
$lang['Centovacast.add_row.box_title'] = 'Añadir servidor CentovaCast';
$lang['Centovacast.add_row.basic_title'] = 'Configuración básica';
$lang['Centovacast.add_row.notes_title'] = 'Notas';
$lang['Centovacast.add_row.add_btn'] = 'Añadir servidor';
$lang['Centovacast.edit_row.box_title'] = 'Editar servidor CentovaCast';
$lang['Centovacast.edit_row.basic_title'] = 'Configuración básica';
$lang['Centovacast.edit_row.notes_title'] = 'Notas';
$lang['Centovacast.edit_row.add_btn'] = 'Editar servidor';
$lang['Centovacast.row_meta.server_name'] = 'Etiqueta del servidor';
$lang['Centovacast.row_meta.hostname'] = 'Nombre de host';
$lang['Centovacast.row_meta.ipaddress'] = 'Dirección IP';
$lang['Centovacast.row_meta.username'] = 'Nombre de usuario';
$lang['Centovacast.row_meta.password'] = 'Contraseña';
$lang['Centovacast.row_meta.port'] = 'Puerto';
$lang['Centovacast.row_meta.use_ssl'] = 'Utilice SSL al conectarse a la API (recomendado)';
$lang['Centovacast.row_meta.account_limit'] = 'Límite de la cuenta';
$lang['Centovacast.package_fields.servertype'] = 'Tipo de servidor';
$lang['Centovacast.package_fields.apptypes'] = 'Tipo AutoDJ';
$lang['Centovacast.package_fields.usesource'] = 'Funciones de AutoDJ';
$lang['Centovacast.package_fields.maxclients'] = 'Máximo de clientes';
$lang['Centovacast.package_fields.maxbitrate'] = 'Bitrate máximo';
$lang['Centovacast.package_fields.transferlimit'] = 'Límite de transferencia';
$lang['Centovacast.package_fields.diskquota'] = 'Cuota de disco';
$lang['Centovacast.service_field.hostname'] = 'Nombre de host';
$lang['Centovacast.service_field.password'] = 'Contraseña';
$lang['Centovacast.service_field.title'] = 'Título';
$lang['Centovacast.service_field.genre'] = 'Género';
$lang['Centovacast.service_field.ipaddress'] = 'Dirección IP';
$lang['Centovacast.service_field.port'] = 'Puerto';
$lang['Centovacast.tab_actions.status_title'] = 'Estado del servidor';
$lang['Centovacast.tab_actions.server_title'] = 'Acciones del servidor';
$lang['Centovacast.tab_actions.action_restart'] = 'Reinicie';
$lang['Centovacast.tab_actions.action_stop'] = 'Stop';
$lang['Centovacast.tab_actions.action_start'] = 'Inicio';
$lang['Centovacast.tab_stats.info_title'] = 'Información';
$lang['Centovacast.tab_stats.info_heading.field'] = 'Campo';
$lang['Centovacast.tab_stats.info_heading.value'] = 'Valor';
$lang['Centovacast.tab_stats.info.username'] = 'Nombre de usuario';
$lang['Centovacast.tab_stats.info.hostname'] = 'Nombre de host';
$lang['Centovacast.tab_stats.info.ipaddress'] = 'Dirección IP';
$lang['Centovacast.tab_stats.info.port'] = 'Puerto';
$lang['Centovacast.tab_stats.info.maxclients'] = 'Máximo de clientes';
$lang['Centovacast.tab_stats.info.samplerate'] = 'Frecuencia de muestreo (Hz)';
$lang['Centovacast.tab_stats.info.maxbitrate'] = 'Bitrate máximo (Kbps)';
$lang['Centovacast.tab_stats.info.adminpassword'] = 'Contraseña';
$lang['Centovacast.tab_stats.info.sourcepassword'] = 'Fuente Contraseña';
$lang['Centovacast.tab_stats.bandwidth_title'] = 'Ancho de banda';
$lang['Centovacast.tab_stats.bandwidth_heading.used'] = 'Usado';
$lang['Centovacast.tab_stats.bandwidth_heading.limit'] = 'Límite';
$lang['Centovacast.tab_stats.bandwidth_value'] = '%1$s MB';
$lang['Centovacast.tab_stats.bandwidth_unlimited'] = 'ilimitado';
$lang['Centovacast.tab_stats.disk_title'] = 'Disco';
$lang['Centovacast.tab_stats.disk_heading.used'] = 'Usado';
$lang['Centovacast.tab_stats.disk_heading.limit'] = 'Límite';
$lang['Centovacast.tab_stats.disk_value'] = '%1$s MB';
$lang['Centovacast.tab_stats.disk_unlimited'] = 'ilimitado';
$lang['Centovacast.tab_client_actions.heading_status'] = 'Estado del servidor';
$lang['Centovacast.tab_client_actions.status_online'] = 'En línea';
$lang['Centovacast.tab_client_actions.status_offline'] = 'Fuera de línea';
$lang['Centovacast.tab_client_actions.heading_actions'] = 'Acciones';
$lang['Centovacast.tab_client_actions.action_restart'] = 'Reinicie';
$lang['Centovacast.tab_client_actions.action_genre'] = 'Cambiar de género';
$lang['Centovacast.tab_client_actions.action_stop'] = 'Stop';
$lang['Centovacast.tab_client_actions.action_radio_title'] = 'Cambiar título de radio';
$lang['Centovacast.tab_client_actions.action_start'] = 'Inicio';
$lang['Centovacast.tab_client_actions.action_password'] = 'Cambiar contraseña';
$lang['Centovacast.tab_client_actions.heading_genre'] = 'Cambiar de género';
$lang['Centovacast.tab_client_actions.field_genre'] = 'Género';
$lang['Centovacast.tab_client_actions.field_genre_submit'] = 'Actualizar el género';
$lang['Centovacast.tab_client_actions.heading_radio_title'] = 'Cambiar título de radio';
$lang['Centovacast.tab_client_actions.field_radio_title'] = 'Título de la radio';
$lang['Centovacast.tab_client_actions.field_radio_title_submit'] = 'Actualizar título de radio';
$lang['Centovacast.tab_client_actions.heading_password'] = 'Cambiar contraseña';
$lang['Centovacast.tab_client_actions.field_password'] = 'Contraseña';
$lang['Centovacast.tab_client_actions.field_password_submit'] = 'Actualizar contraseña';
$lang['Centovacast.tab_client_stats.info_title'] = 'Información';
$lang['Centovacast.tab_client_stats.info_heading.field'] = 'Campo';
$lang['Centovacast.tab_client_stats.info_heading.value'] = 'Valor';
$lang['Centovacast.tab_client_stats.info.username'] = 'Nombre de usuario';
$lang['Centovacast.tab_client_stats.info.hostname'] = 'Nombre de host';
$lang['Centovacast.tab_client_stats.info.ipaddress'] = 'Dirección IP';
$lang['Centovacast.tab_client_stats.info.port'] = 'Puerto';
$lang['Centovacast.tab_client_stats.info.maxclients'] = 'Máximo de clientes';
$lang['Centovacast.tab_client_stats.info.samplerate'] = 'Frecuencia de muestreo (Hz)';
$lang['Centovacast.tab_client_stats.info.maxbitrate'] = 'Bitrate máximo (Kbps)';
$lang['Centovacast.tab_client_stats.info.adminpassword'] = 'Contraseña';
$lang['Centovacast.tab_client_stats.info.sourcepassword'] = 'Fuente Contraseña';
$lang['Centovacast.tab_client_stats.bandwidth_title'] = 'Uso de ancho de banda (mes hasta la fecha)';
$lang['Centovacast.tab_client_stats.disk_title'] = 'Uso del disco';
$lang['Centovacast.tab_client_stats.usage'] = '(%1$s MB/%2$s MB)';
$lang['Centovacast.tab_client_stats.usage_unlimited'] = '(%1$s MB/∞)';
$lang['Centovacast.service_info.hostname'] = 'Nombre de host';
$lang['Centovacast.service_info.username'] = 'Nombre de usuario';
$lang['Centovacast.service_info.password'] = 'Contraseña';
$lang['Centovacast.service_info.options'] = 'Opciones';
$lang['Centovacast.service_info.option_login'] = 'Inicio de sesión';
$lang['Centovacast.package_fields.tooltip.maxclients'] = 'Especifica el número máximo de oyentes que pueden sintonizar simultáneamente el flujo.';
$lang['Centovacast.package_fields.tooltip.maxbitrate'] = 'Especifica la tasa de bits máxima para este flujo, en kilobits por segundo (kbps).';
$lang['Centovacast.package_fields.tooltip.transferlimit'] = 'Especifica la transferencia de datos mensual máxima para este flujo, en megabytes (MB). 0 significa ilimitado.';
$lang['Centovacast.package_fields.tooltip.diskquota'] = 'Especifica el espacio máximo en disco para este flujo, en megabytes (MB). 0 significa ilimitado.';
$lang['Centovacast.service_field.tooltip.ipaddress'] = 'Sobrescribir la dirección IP por defecto.';
$lang['Centovacast.service_field.tooltip.port'] = 'Establezca un puerto específico para la cuenta, déjelo en blanco para seleccionar un puerto automáticamente.';
$lang['Centovacast.!error.server_name_valid'] = 'Debe introducir una Etiqueta de servidor.';
$lang['Centovacast.!error.host_name_valid'] = 'El nombre de host no es válido.';
$lang['Centovacast.!error.user_name_valid'] = 'El nombre de usuario no es válido.';
$lang['Centovacast.!error.password_valid'] = 'La contraseña no es válida.';
$lang['Centovacast.!error.password_valid_connection'] = 'No se ha podido establecer la conexión con el servidor. Compruebe que el nombre de host, el nombre de usuario, el puerto y la contraseña son correctos.';
$lang['Centovacast.!error.account_limit_valid'] = 'El Límite de cuenta debe dejarse en blanco (para cuentas ilimitadas) o establecerse en algún valor entero.';
$lang['Centovacast.!error.port_valid'] = 'El puerto debe ser un valor numérico.';
$lang['Centovacast.!error.meta[servertype].valid'] = 'El tipo de servidor no es válido.';
$lang['Centovacast.!error.meta[apptypes].valid'] = 'El tipo de DJ automático parece no ser válido.';
$lang['Centovacast.!error.meta[usesource].valid'] = 'Las capacidades de Auto DJ parecen no ser válidas.';
$lang['Centovacast.!error.meta[maxclients].valid'] = 'Los Clientes máximos deben ser un valor numérico.';
$lang['Centovacast.!error.meta[maxbitrate].valid'] = 'La tasa de bits máxima debe ser un valor numérico.';
$lang['Centovacast.!error.meta[transferlimit].valid'] = 'El Límite de transferencia debe ser un valor numérico.';
$lang['Centovacast.!error.meta[diskquota].valid'] = 'La Cuota de Disco debe ser un valor numérico.';
$lang['Centovacast.!error.api.internal'] = 'Se ha producido un error interno o el servidor no ha respondido a la solicitud.';
$lang['Centovacast.!error.module_row.missing'] = 'Se ha producido un error interno. La fila del módulo no está disponible.';
$lang['Centovacast.!error.centovacast_hostname.format'] = 'Introduzca un nombre de host válido, por ejemplo, dominio.com.';
$lang['Centovacast.!error.centovacast_adminpassword.valid'] = 'La contraseña debe tener al menos 5 caracteres.';

