<?php
/**
 * WARNING: Do not edit by hand, this file was generated by Crank:
 *
 * https://github.com/gocardless/crank
 */

namespace GoCardlessPro\Services;

use \GoCardlessPro\Core\Paginator;
use \GoCardlessPro\Core\Util;
use \GoCardlessPro\Core\ListResponse;
use \GoCardlessPro\Resources\Refund;
use \GoCardlessPro\Core\Exception\InvalidStateException;


/**
 * Service that provides access to the Refund
 * endpoints of the API
 */
class RefundsService extends BaseService
{

    protected $envelope_key   = 'refunds';
    protected $resource_class = '\GoCardlessPro\Resources\Refund';


    /**
    * Create a refund
    *
    * Example URL: /refunds
    *
    * @param  string[mixed] $params An associative array for any params
    * @return Refund
    **/
    public function create($params = array())
    {
        $path = "/refunds";
        if(isset($params['params'])) { 
            $params['body'] = json_encode(array($this->envelope_key => (object)$params['params']));
        
            unset($params['params']);
        }

        
        try {
            $response = $this->api_client->post($path, $params);
        } catch(InvalidStateException $e) {
            if ($e->isIdempotentCreationConflict()) {
                return $this->get($e->getConflictingResourceId());
            }

            throw $e;
        }
        

        return $this->getResourceForResponse($response);
    }

    /**
    * List refunds
    *
    * Example URL: /refunds
    *
    * @param  string[mixed] $params An associative array for any params
    * @return ListResponse
    **/
    protected function _doList($params = array())
    {
        $path = "/refunds";
        if(isset($params['params'])) { $params['query'] = $params['params'];
            unset($params['params']);
        }

        
        $response = $this->api_client->get($path, $params);
        

        return $this->getResourceForResponse($response);
    }

    /**
    * Get a single refund
    *
    * Example URL: /refunds/:identity
    *
    * @param  string        $identity Unique identifier, beginning with "RF".
    * @param  string[mixed] $params   An associative array for any params
    * @return Refund
    **/
    public function get($identity, $params = array())
    {
        $path = Util::subUrl(
            '/refunds/:identity',
            array(
                
                'identity' => $identity
            )
        );
        if(isset($params['params'])) { $params['query'] = $params['params'];
            unset($params['params']);
        }

        
        $response = $this->api_client->get($path, $params);
        

        return $this->getResourceForResponse($response);
    }

    /**
    * Update a refund
    *
    * Example URL: /refunds/:identity
    *
    * @param  string        $identity Unique identifier, beginning with "RF".
    * @param  string[mixed] $params   An associative array for any params
    * @return Refund
    **/
    public function update($identity, $params = array())
    {
        $path = Util::subUrl(
            '/refunds/:identity',
            array(
                
                'identity' => $identity
            )
        );
        if(isset($params['params'])) { 
            $params['body'] = json_encode(array($this->envelope_key => (object)$params['params']));
        
            unset($params['params']);
        }

        
        $response = $this->api_client->put($path, $params);
        

        return $this->getResourceForResponse($response);
    }

    /**
    * List refunds
    *
    * Example URL: /refunds
    *
    * @param  string[mixed] $params
    * @return Paginator
    **/
    public function all($params = array())
    {
        return new Paginator($this, $params);
    }

}
