<?php
/**
 * ZoneServiceApi
 * PHP version 5
 *
 * @category Class
 * @package  Openprovider\Api\Rest\Client\Dns
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * DNS
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 1.0.0-beta
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 4.0.3
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Openprovider\Api\Rest\Client\Dns\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Openprovider\Api\Rest\Client\Base\ApiException;
use Openprovider\Api\Rest\Client\Base\Configuration;
use Openprovider\Api\Rest\Client\Base\HeaderSelector;
use Openprovider\Api\Rest\Client\Base\ObjectSerializer;

/**
 * ZoneServiceApi Class Doc Comment
 *
 * @category Class
 * @package  Openprovider\Api\Rest\Client\Dns
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ZoneServiceApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $host_index (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $host_index = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $host_index;
    }

    /**
     * Set the host index
     *
     * @param  int Host index (required)
     */
    public function setHostIndex($host_index)
    {
        $this->hostIndex = $host_index;
    }

    /**
     * Get the host index
     *
     * @return Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createZone
     *
     * Create zone
     *
     * @param  \Openprovider\Api\Rest\Client\Dns\Model\ZoneCreateZoneRequest $body body (required)
     *
     * @throws \Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Openprovider\Api\Rest\Client\Dns\Model\ZoneZoneBoolResponse|\Openprovider\Api\Rest\Client\Dns\Model\ErrorError
     */
    public function createZone($body)
    {
        list($response) = $this->createZoneWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation createZoneWithHttpInfo
     *
     * Create zone
     *
     * @param  \Openprovider\Api\Rest\Client\Dns\Model\ZoneCreateZoneRequest $body (required)
     *
     * @throws Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Openprovider\Api\Rest\Client\Dns\Model\ZoneZoneBoolResponse|\Openprovider\Api\Rest\Client\Dns\Model\ErrorError, HTTP status code, HTTP response headers (array of strings)
     */
    public function createZoneWithHttpInfo($body)
    {
        $request = $this->createZoneRequest($body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Openprovider\Api\Rest\Client\Dns\Model\ZoneZoneBoolResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\Dns\Model\ZoneZoneBoolResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\Openprovider\Api\Rest\Client\Dns\Model\ErrorError' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\Dns\Model\ErrorError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Openprovider\Api\Rest\Client\Dns\Model\ZoneZoneBoolResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\Dns\Model\ZoneZoneBoolResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\Dns\Model\ErrorError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createZoneAsync
     *
     * Create zone
     *
     * @param  \Openprovider\Api\Rest\Client\Dns\Model\ZoneCreateZoneRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createZoneAsync($body)
    {
        return $this->createZoneAsyncWithHttpInfo($body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createZoneAsyncWithHttpInfo
     *
     * Create zone
     *
     * @param  \Openprovider\Api\Rest\Client\Dns\Model\ZoneCreateZoneRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createZoneAsyncWithHttpInfo($body)
    {
        $returnType = '\Openprovider\Api\Rest\Client\Dns\Model\ZoneZoneBoolResponse';
        $request = $this->createZoneRequest($body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createZone'
     *
     * @param  \Openprovider\Api\Rest\Client\Dns\Model\ZoneCreateZoneRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createZoneRequest($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling createZone'
            );
        }

        $resourcePath = '/v1beta/dns/zones';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteZone
     *
     * Delete zone
     *
     * @param  string $name Name of the domain to which DNS zone corresponds (required)
     * @param  int $id DNS zone ID. (optional)
     * @param  string $domain_name Domain name without extension. (optional)
     * @param  string $domain_extension Domain extension. (optional)
     * @param  string $provider Name of the DNS provider. Set provider&#x3D;sectigo in case of sectigo premium DNS zone should be deleted. (optional)
     *
     * @throws \Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Openprovider\Api\Rest\Client\Dns\Model\ZoneZoneBoolResponse|\Openprovider\Api\Rest\Client\Dns\Model\ErrorError
     */
    public function deleteZone($name, $id = null, $domain_name = null, $domain_extension = null, $provider = null)
    {
        list($response) = $this->deleteZoneWithHttpInfo($name, $id, $domain_name, $domain_extension, $provider);
        return $response;
    }

    /**
     * Operation deleteZoneWithHttpInfo
     *
     * Delete zone
     *
     * @param  string $name Name of the domain to which DNS zone corresponds (required)
     * @param  int $id DNS zone ID. (optional)
     * @param  string $domain_name Domain name without extension. (optional)
     * @param  string $domain_extension Domain extension. (optional)
     * @param  string $provider Name of the DNS provider. Set provider&#x3D;sectigo in case of sectigo premium DNS zone should be deleted. (optional)
     *
     * @throws Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Openprovider\Api\Rest\Client\Dns\Model\ZoneZoneBoolResponse|\Openprovider\Api\Rest\Client\Dns\Model\ErrorError, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteZoneWithHttpInfo($name, $id = null, $domain_name = null, $domain_extension = null, $provider = null)
    {
        $request = $this->deleteZoneRequest($name, $id, $domain_name, $domain_extension, $provider);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Openprovider\Api\Rest\Client\Dns\Model\ZoneZoneBoolResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\Dns\Model\ZoneZoneBoolResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\Openprovider\Api\Rest\Client\Dns\Model\ErrorError' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\Dns\Model\ErrorError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Openprovider\Api\Rest\Client\Dns\Model\ZoneZoneBoolResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\Dns\Model\ZoneZoneBoolResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\Dns\Model\ErrorError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteZoneAsync
     *
     * Delete zone
     *
     * @param  string $name Name of the domain to which DNS zone corresponds (required)
     * @param  int $id DNS zone ID. (optional)
     * @param  string $domain_name Domain name without extension. (optional)
     * @param  string $domain_extension Domain extension. (optional)
     * @param  string $provider Name of the DNS provider. Set provider&#x3D;sectigo in case of sectigo premium DNS zone should be deleted. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteZoneAsync($name, $id = null, $domain_name = null, $domain_extension = null, $provider = null)
    {
        return $this->deleteZoneAsyncWithHttpInfo($name, $id, $domain_name, $domain_extension, $provider)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteZoneAsyncWithHttpInfo
     *
     * Delete zone
     *
     * @param  string $name Name of the domain to which DNS zone corresponds (required)
     * @param  int $id DNS zone ID. (optional)
     * @param  string $domain_name Domain name without extension. (optional)
     * @param  string $domain_extension Domain extension. (optional)
     * @param  string $provider Name of the DNS provider. Set provider&#x3D;sectigo in case of sectigo premium DNS zone should be deleted. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteZoneAsyncWithHttpInfo($name, $id = null, $domain_name = null, $domain_extension = null, $provider = null)
    {
        $returnType = '\Openprovider\Api\Rest\Client\Dns\Model\ZoneZoneBoolResponse';
        $request = $this->deleteZoneRequest($name, $id, $domain_name, $domain_extension, $provider);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteZone'
     *
     * @param  string $name Name of the domain to which DNS zone corresponds (required)
     * @param  int $id DNS zone ID. (optional)
     * @param  string $domain_name Domain name without extension. (optional)
     * @param  string $domain_extension Domain extension. (optional)
     * @param  string $provider Name of the DNS provider. Set provider&#x3D;sectigo in case of sectigo premium DNS zone should be deleted. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function deleteZoneRequest($name, $id = null, $domain_name = null, $domain_extension = null, $provider = null)
    {
        // verify the required parameter 'name' is set
        if ($name === null || (is_array($name) && count($name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $name when calling deleteZone'
            );
        }

        $resourcePath = '/v1beta/dns/zones/{name}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($id !== null) {
            $queryParams['id'] = ObjectSerializer::toQueryValue($id);
        }
        // query params
        if ($domain_name !== null) {
            $queryParams['domain.name'] = ObjectSerializer::toQueryValue($domain_name);
        }
        // query params
        if ($domain_extension !== null) {
            $queryParams['domain.extension'] = ObjectSerializer::toQueryValue($domain_extension);
        }
        // query params
        if ($provider !== null) {
            $queryParams['provider'] = ObjectSerializer::toQueryValue($provider);
        }

        // path params
        if ($name !== null) {
            $resourcePath = str_replace(
                '{' . 'name' . '}',
                ObjectSerializer::toPathValue($name),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getZone
     *
     * Get zone
     *
     * @param  string $name Name of the domain to which DNS zone corresponds (required)
     * @param  string $id DNS zone ID. (optional)
     * @param  bool $with_records Indicates, whether DNS records should be displayed in output. (optional, default to true)
     * @param  bool $with_history Indicates, whether DNS zone history should be displayed in output. (optional, default to true)
     * @param  bool $with_dnskey Indicates, whether DNSSEC keys should be displayed in output. (optional)
     * @param  string $provider Name of the DNS provider. Set provider&#x3D;sectigo in case of only sectigo premium DNS zone should be retrieved. (optional)
     *
     * @throws \Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Openprovider\Api\Rest\Client\Dns\Model\ZoneGetZoneResponse|\Openprovider\Api\Rest\Client\Dns\Model\ErrorError
     */
    public function getZone($name, $id = null, $with_records = true, $with_history = true, $with_dnskey = null, $provider = null)
    {
        list($response) = $this->getZoneWithHttpInfo($name, $id, $with_records, $with_history, $with_dnskey, $provider);
        return $response;
    }

    /**
     * Operation getZoneWithHttpInfo
     *
     * Get zone
     *
     * @param  string $name Name of the domain to which DNS zone corresponds (required)
     * @param  string $id DNS zone ID. (optional)
     * @param  bool $with_records Indicates, whether DNS records should be displayed in output. (optional, default to true)
     * @param  bool $with_history Indicates, whether DNS zone history should be displayed in output. (optional, default to true)
     * @param  bool $with_dnskey Indicates, whether DNSSEC keys should be displayed in output. (optional)
     * @param  string $provider Name of the DNS provider. Set provider&#x3D;sectigo in case of only sectigo premium DNS zone should be retrieved. (optional)
     *
     * @throws Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Openprovider\Api\Rest\Client\Dns\Model\ZoneGetZoneResponse|\Openprovider\Api\Rest\Client\Dns\Model\ErrorError, HTTP status code, HTTP response headers (array of strings)
     */
    public function getZoneWithHttpInfo($name, $id = null, $with_records = true, $with_history = true, $with_dnskey = null, $provider = null)
    {
        $request = $this->getZoneRequest($name, $id, $with_records, $with_history, $with_dnskey, $provider);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Openprovider\Api\Rest\Client\Dns\Model\ZoneGetZoneResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\Dns\Model\ZoneGetZoneResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\Openprovider\Api\Rest\Client\Dns\Model\ErrorError' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\Dns\Model\ErrorError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Openprovider\Api\Rest\Client\Dns\Model\ZoneGetZoneResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\Dns\Model\ZoneGetZoneResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\Dns\Model\ErrorError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getZoneAsync
     *
     * Get zone
     *
     * @param  string $name Name of the domain to which DNS zone corresponds (required)
     * @param  string $id DNS zone ID. (optional)
     * @param  bool $with_records Indicates, whether DNS records should be displayed in output. (optional, default to true)
     * @param  bool $with_history Indicates, whether DNS zone history should be displayed in output. (optional, default to true)
     * @param  bool $with_dnskey Indicates, whether DNSSEC keys should be displayed in output. (optional)
     * @param  string $provider Name of the DNS provider. Set provider&#x3D;sectigo in case of only sectigo premium DNS zone should be retrieved. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getZoneAsync($name, $id = null, $with_records = true, $with_history = true, $with_dnskey = null, $provider = null)
    {
        return $this->getZoneAsyncWithHttpInfo($name, $id, $with_records, $with_history, $with_dnskey, $provider)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getZoneAsyncWithHttpInfo
     *
     * Get zone
     *
     * @param  string $name Name of the domain to which DNS zone corresponds (required)
     * @param  string $id DNS zone ID. (optional)
     * @param  bool $with_records Indicates, whether DNS records should be displayed in output. (optional, default to true)
     * @param  bool $with_history Indicates, whether DNS zone history should be displayed in output. (optional, default to true)
     * @param  bool $with_dnskey Indicates, whether DNSSEC keys should be displayed in output. (optional)
     * @param  string $provider Name of the DNS provider. Set provider&#x3D;sectigo in case of only sectigo premium DNS zone should be retrieved. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getZoneAsyncWithHttpInfo($name, $id = null, $with_records = true, $with_history = true, $with_dnskey = null, $provider = null)
    {
        $returnType = '\Openprovider\Api\Rest\Client\Dns\Model\ZoneGetZoneResponse';
        $request = $this->getZoneRequest($name, $id, $with_records, $with_history, $with_dnskey, $provider);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getZone'
     *
     * @param  string $name Name of the domain to which DNS zone corresponds (required)
     * @param  string $id DNS zone ID. (optional)
     * @param  bool $with_records Indicates, whether DNS records should be displayed in output. (optional, default to true)
     * @param  bool $with_history Indicates, whether DNS zone history should be displayed in output. (optional, default to true)
     * @param  bool $with_dnskey Indicates, whether DNSSEC keys should be displayed in output. (optional)
     * @param  string $provider Name of the DNS provider. Set provider&#x3D;sectigo in case of only sectigo premium DNS zone should be retrieved. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getZoneRequest($name, $id = null, $with_records = true, $with_history = true, $with_dnskey = null, $provider = null)
    {
        // verify the required parameter 'name' is set
        if ($name === null || (is_array($name) && count($name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $name when calling getZone'
            );
        }

        $resourcePath = '/v1beta/dns/zones/{name}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($id !== null) {
            $queryParams['id'] = ObjectSerializer::toQueryValue($id);
        }
        // query params
        if ($with_records !== null) {
            $queryParams['with_records'] = ObjectSerializer::toQueryValue($with_records);
        }
        // query params
        if ($with_history !== null) {
            $queryParams['with_history'] = ObjectSerializer::toQueryValue($with_history);
        }
        // query params
        if ($with_dnskey !== null) {
            $queryParams['with_dnskey'] = ObjectSerializer::toQueryValue($with_dnskey);
        }
        // query params
        if ($provider !== null) {
            $queryParams['provider'] = ObjectSerializer::toQueryValue($provider);
        }

        // path params
        if ($name !== null) {
            $resourcePath = str_replace(
                '{' . 'name' . '}',
                ObjectSerializer::toPathValue($name),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listZones
     *
     * List zones
     *
     * @param  int $limit Limits the number of objects in the output. (default value: 100, maximum value: 500). (optional, default to 100)
     * @param  int $offset Used to retrieve all objects from a certain offset up to the. (default value: 0). (optional)
     * @param  string $order_by_creation_date Sorting type (asc/desc). (optional, default to 'desc')
     * @param  string $order_by_modification_date Sorting type (asc/desc). (optional)
     * @param  string $order_by_name Sorting type (asc/desc). (optional)
     * @param  string $type DNS zone type (master or slave). (optional)
     * @param  string $name_pattern DNS zone name pattern. Wildcard (*) can be used. (optional)
     * @param  bool $with_records Indicates, whether DNS records should be displayed in output. (optional)
     * @param  bool $with_history Indicates, whether DNS zone history should be displayed in output. (optional)
     * @param  bool $with_dnskey Indicates, whether DNSSEC keys should be displayed in output. (optional)
     * @param  string $provider Name of the DNS provider. Set provider&#x3D;sectigo in case of only sectigo premium DNS zone should be retrieved. (optional)
     *
     * @throws \Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Openprovider\Api\Rest\Client\Dns\Model\ZoneListZonesResponse|\Openprovider\Api\Rest\Client\Dns\Model\ErrorError
     */
    public function listZones($limit = 100, $offset = null, $order_by_creation_date = 'desc', $order_by_modification_date = null, $order_by_name = null, $type = null, $name_pattern = null, $with_records = null, $with_history = null, $with_dnskey = null, $provider = null)
    {
        list($response) = $this->listZonesWithHttpInfo($limit, $offset, $order_by_creation_date, $order_by_modification_date, $order_by_name, $type, $name_pattern, $with_records, $with_history, $with_dnskey, $provider);
        return $response;
    }

    /**
     * Operation listZonesWithHttpInfo
     *
     * List zones
     *
     * @param  int $limit Limits the number of objects in the output. (default value: 100, maximum value: 500). (optional, default to 100)
     * @param  int $offset Used to retrieve all objects from a certain offset up to the. (default value: 0). (optional)
     * @param  string $order_by_creation_date Sorting type (asc/desc). (optional, default to 'desc')
     * @param  string $order_by_modification_date Sorting type (asc/desc). (optional)
     * @param  string $order_by_name Sorting type (asc/desc). (optional)
     * @param  string $type DNS zone type (master or slave). (optional)
     * @param  string $name_pattern DNS zone name pattern. Wildcard (*) can be used. (optional)
     * @param  bool $with_records Indicates, whether DNS records should be displayed in output. (optional)
     * @param  bool $with_history Indicates, whether DNS zone history should be displayed in output. (optional)
     * @param  bool $with_dnskey Indicates, whether DNSSEC keys should be displayed in output. (optional)
     * @param  string $provider Name of the DNS provider. Set provider&#x3D;sectigo in case of only sectigo premium DNS zone should be retrieved. (optional)
     *
     * @throws Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Openprovider\Api\Rest\Client\Dns\Model\ZoneListZonesResponse|\Openprovider\Api\Rest\Client\Dns\Model\ErrorError, HTTP status code, HTTP response headers (array of strings)
     */
    public function listZonesWithHttpInfo($limit = 100, $offset = null, $order_by_creation_date = 'desc', $order_by_modification_date = null, $order_by_name = null, $type = null, $name_pattern = null, $with_records = null, $with_history = null, $with_dnskey = null, $provider = null)
    {
        $request = $this->listZonesRequest($limit, $offset, $order_by_creation_date, $order_by_modification_date, $order_by_name, $type, $name_pattern, $with_records, $with_history, $with_dnskey, $provider);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Openprovider\Api\Rest\Client\Dns\Model\ZoneListZonesResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\Dns\Model\ZoneListZonesResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\Openprovider\Api\Rest\Client\Dns\Model\ErrorError' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\Dns\Model\ErrorError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Openprovider\Api\Rest\Client\Dns\Model\ZoneListZonesResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\Dns\Model\ZoneListZonesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\Dns\Model\ErrorError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listZonesAsync
     *
     * List zones
     *
     * @param  int $limit Limits the number of objects in the output. (default value: 100, maximum value: 500). (optional, default to 100)
     * @param  int $offset Used to retrieve all objects from a certain offset up to the. (default value: 0). (optional)
     * @param  string $order_by_creation_date Sorting type (asc/desc). (optional, default to 'desc')
     * @param  string $order_by_modification_date Sorting type (asc/desc). (optional)
     * @param  string $order_by_name Sorting type (asc/desc). (optional)
     * @param  string $type DNS zone type (master or slave). (optional)
     * @param  string $name_pattern DNS zone name pattern. Wildcard (*) can be used. (optional)
     * @param  bool $with_records Indicates, whether DNS records should be displayed in output. (optional)
     * @param  bool $with_history Indicates, whether DNS zone history should be displayed in output. (optional)
     * @param  bool $with_dnskey Indicates, whether DNSSEC keys should be displayed in output. (optional)
     * @param  string $provider Name of the DNS provider. Set provider&#x3D;sectigo in case of only sectigo premium DNS zone should be retrieved. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listZonesAsync($limit = 100, $offset = null, $order_by_creation_date = 'desc', $order_by_modification_date = null, $order_by_name = null, $type = null, $name_pattern = null, $with_records = null, $with_history = null, $with_dnskey = null, $provider = null)
    {
        return $this->listZonesAsyncWithHttpInfo($limit, $offset, $order_by_creation_date, $order_by_modification_date, $order_by_name, $type, $name_pattern, $with_records, $with_history, $with_dnskey, $provider)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listZonesAsyncWithHttpInfo
     *
     * List zones
     *
     * @param  int $limit Limits the number of objects in the output. (default value: 100, maximum value: 500). (optional, default to 100)
     * @param  int $offset Used to retrieve all objects from a certain offset up to the. (default value: 0). (optional)
     * @param  string $order_by_creation_date Sorting type (asc/desc). (optional, default to 'desc')
     * @param  string $order_by_modification_date Sorting type (asc/desc). (optional)
     * @param  string $order_by_name Sorting type (asc/desc). (optional)
     * @param  string $type DNS zone type (master or slave). (optional)
     * @param  string $name_pattern DNS zone name pattern. Wildcard (*) can be used. (optional)
     * @param  bool $with_records Indicates, whether DNS records should be displayed in output. (optional)
     * @param  bool $with_history Indicates, whether DNS zone history should be displayed in output. (optional)
     * @param  bool $with_dnskey Indicates, whether DNSSEC keys should be displayed in output. (optional)
     * @param  string $provider Name of the DNS provider. Set provider&#x3D;sectigo in case of only sectigo premium DNS zone should be retrieved. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listZonesAsyncWithHttpInfo($limit = 100, $offset = null, $order_by_creation_date = 'desc', $order_by_modification_date = null, $order_by_name = null, $type = null, $name_pattern = null, $with_records = null, $with_history = null, $with_dnskey = null, $provider = null)
    {
        $returnType = '\Openprovider\Api\Rest\Client\Dns\Model\ZoneListZonesResponse';
        $request = $this->listZonesRequest($limit, $offset, $order_by_creation_date, $order_by_modification_date, $order_by_name, $type, $name_pattern, $with_records, $with_history, $with_dnskey, $provider);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listZones'
     *
     * @param  int $limit Limits the number of objects in the output. (default value: 100, maximum value: 500). (optional, default to 100)
     * @param  int $offset Used to retrieve all objects from a certain offset up to the. (default value: 0). (optional)
     * @param  string $order_by_creation_date Sorting type (asc/desc). (optional, default to 'desc')
     * @param  string $order_by_modification_date Sorting type (asc/desc). (optional)
     * @param  string $order_by_name Sorting type (asc/desc). (optional)
     * @param  string $type DNS zone type (master or slave). (optional)
     * @param  string $name_pattern DNS zone name pattern. Wildcard (*) can be used. (optional)
     * @param  bool $with_records Indicates, whether DNS records should be displayed in output. (optional)
     * @param  bool $with_history Indicates, whether DNS zone history should be displayed in output. (optional)
     * @param  bool $with_dnskey Indicates, whether DNSSEC keys should be displayed in output. (optional)
     * @param  string $provider Name of the DNS provider. Set provider&#x3D;sectigo in case of only sectigo premium DNS zone should be retrieved. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function listZonesRequest($limit = 100, $offset = null, $order_by_creation_date = 'desc', $order_by_modification_date = null, $order_by_name = null, $type = null, $name_pattern = null, $with_records = null, $with_history = null, $with_dnskey = null, $provider = null)
    {

        $resourcePath = '/v1beta/dns/zones';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($limit !== null) {
            $queryParams['limit'] = ObjectSerializer::toQueryValue($limit);
        }
        // query params
        if ($offset !== null) {
            $queryParams['offset'] = ObjectSerializer::toQueryValue($offset);
        }
        // query params
        if ($order_by_creation_date !== null) {
            $queryParams['order_by.creation_date'] = ObjectSerializer::toQueryValue($order_by_creation_date);
        }
        // query params
        if ($order_by_modification_date !== null) {
            $queryParams['order_by.modification_date'] = ObjectSerializer::toQueryValue($order_by_modification_date);
        }
        // query params
        if ($order_by_name !== null) {
            $queryParams['order_by.name'] = ObjectSerializer::toQueryValue($order_by_name);
        }
        // query params
        if ($type !== null) {
            $queryParams['type'] = ObjectSerializer::toQueryValue($type);
        }
        // query params
        if ($name_pattern !== null) {
            $queryParams['name_pattern'] = ObjectSerializer::toQueryValue($name_pattern);
        }
        // query params
        if ($with_records !== null) {
            $queryParams['with_records'] = ObjectSerializer::toQueryValue($with_records);
        }
        // query params
        if ($with_history !== null) {
            $queryParams['with_history'] = ObjectSerializer::toQueryValue($with_history);
        }
        // query params
        if ($with_dnskey !== null) {
            $queryParams['with_dnskey'] = ObjectSerializer::toQueryValue($with_dnskey);
        }
        // query params
        if ($provider !== null) {
            $queryParams['provider'] = ObjectSerializer::toQueryValue($provider);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateZone
     *
     * Update zone
     *
     * @param  string $name Name of the domain to which DNS zone corresponds (required)
     * @param  \Openprovider\Api\Rest\Client\Dns\Model\ZoneUpdateZoneRequest $body body (required)
     *
     * @throws \Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Openprovider\Api\Rest\Client\Dns\Model\ZoneZoneBoolResponse|\Openprovider\Api\Rest\Client\Dns\Model\ErrorError
     */
    public function updateZone($name, $body)
    {
        list($response) = $this->updateZoneWithHttpInfo($name, $body);
        return $response;
    }

    /**
     * Operation updateZoneWithHttpInfo
     *
     * Update zone
     *
     * @param  string $name Name of the domain to which DNS zone corresponds (required)
     * @param  \Openprovider\Api\Rest\Client\Dns\Model\ZoneUpdateZoneRequest $body (required)
     *
     * @throws Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Openprovider\Api\Rest\Client\Dns\Model\ZoneZoneBoolResponse|\Openprovider\Api\Rest\Client\Dns\Model\ErrorError, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateZoneWithHttpInfo($name, $body)
    {
        $request = $this->updateZoneRequest($name, $body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Openprovider\Api\Rest\Client\Dns\Model\ZoneZoneBoolResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\Dns\Model\ZoneZoneBoolResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\Openprovider\Api\Rest\Client\Dns\Model\ErrorError' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\Dns\Model\ErrorError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Openprovider\Api\Rest\Client\Dns\Model\ZoneZoneBoolResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\Dns\Model\ZoneZoneBoolResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\Dns\Model\ErrorError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateZoneAsync
     *
     * Update zone
     *
     * @param  string $name Name of the domain to which DNS zone corresponds (required)
     * @param  \Openprovider\Api\Rest\Client\Dns\Model\ZoneUpdateZoneRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateZoneAsync($name, $body)
    {
        return $this->updateZoneAsyncWithHttpInfo($name, $body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateZoneAsyncWithHttpInfo
     *
     * Update zone
     *
     * @param  string $name Name of the domain to which DNS zone corresponds (required)
     * @param  \Openprovider\Api\Rest\Client\Dns\Model\ZoneUpdateZoneRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateZoneAsyncWithHttpInfo($name, $body)
    {
        $returnType = '\Openprovider\Api\Rest\Client\Dns\Model\ZoneZoneBoolResponse';
        $request = $this->updateZoneRequest($name, $body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateZone'
     *
     * @param  string $name Name of the domain to which DNS zone corresponds (required)
     * @param  \Openprovider\Api\Rest\Client\Dns\Model\ZoneUpdateZoneRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function updateZoneRequest($name, $body)
    {
        // verify the required parameter 'name' is set
        if ($name === null || (is_array($name) && count($name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $name when calling updateZone'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling updateZone'
            );
        }

        $resourcePath = '/v1beta/dns/zones/{name}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($name !== null) {
            $resourcePath = str_replace(
                '{' . 'name' . '}',
                ObjectSerializer::toPathValue($name),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
