<?php
/**
 * CustomerApi
 * PHP version 5
 *
 * @category Class
 * @package  Openprovider\Api\Rest\Client\Person
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Reseller/Customer
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 1.0.0-beta
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 4.0.3
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Openprovider\Api\Rest\Client\Person\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Openprovider\Api\Rest\Client\Base\ApiException;
use Openprovider\Api\Rest\Client\Base\Configuration;
use Openprovider\Api\Rest\Client\Base\HeaderSelector;
use Openprovider\Api\Rest\Client\Base\ObjectSerializer;

/**
 * CustomerApi Class Doc Comment
 *
 * @category Class
 * @package  Openprovider\Api\Rest\Client\Person
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class CustomerApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $host_index (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $host_index = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $host_index;
    }

    /**
     * Set the host index
     *
     * @param  int Host index (required)
     */
    public function setHostIndex($host_index)
    {
        $this->hostIndex = $host_index;
    }

    /**
     * Get the host index
     *
     * @return Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createCustomer
     *
     * Create customer
     *
     * @param  \Openprovider\Api\Rest\Client\Person\Model\CustomerCreateCustomerRequest $body body (required)
     *
     * @throws \Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Openprovider\Api\Rest\Client\Person\Model\CustomerCreateCustomerResponse|\Openprovider\Api\Rest\Client\Person\Model\ErrorError
     */
    public function createCustomer($body)
    {
        list($response) = $this->createCustomerWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation createCustomerWithHttpInfo
     *
     * Create customer
     *
     * @param  \Openprovider\Api\Rest\Client\Person\Model\CustomerCreateCustomerRequest $body (required)
     *
     * @throws Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Openprovider\Api\Rest\Client\Person\Model\CustomerCreateCustomerResponse|\Openprovider\Api\Rest\Client\Person\Model\ErrorError, HTTP status code, HTTP response headers (array of strings)
     */
    public function createCustomerWithHttpInfo($body)
    {
        $request = $this->createCustomerRequest($body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Openprovider\Api\Rest\Client\Person\Model\CustomerCreateCustomerResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\Person\Model\CustomerCreateCustomerResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\Openprovider\Api\Rest\Client\Person\Model\ErrorError' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\Person\Model\ErrorError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Openprovider\Api\Rest\Client\Person\Model\CustomerCreateCustomerResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\Person\Model\CustomerCreateCustomerResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\Person\Model\ErrorError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createCustomerAsync
     *
     * Create customer
     *
     * @param  \Openprovider\Api\Rest\Client\Person\Model\CustomerCreateCustomerRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCustomerAsync($body)
    {
        return $this->createCustomerAsyncWithHttpInfo($body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createCustomerAsyncWithHttpInfo
     *
     * Create customer
     *
     * @param  \Openprovider\Api\Rest\Client\Person\Model\CustomerCreateCustomerRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCustomerAsyncWithHttpInfo($body)
    {
        $returnType = '\Openprovider\Api\Rest\Client\Person\Model\CustomerCreateCustomerResponse';
        $request = $this->createCustomerRequest($body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createCustomer'
     *
     * @param  \Openprovider\Api\Rest\Client\Person\Model\CustomerCreateCustomerRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createCustomerRequest($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling createCustomer'
            );
        }

        $resourcePath = '/v1beta/customers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteCustomer
     *
     * Delete customer
     *
     * @param  string $handle Customer unique identifier or handle, which can be created via CreateCustomer API method (required)
     *
     * @throws \Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Openprovider\Api\Rest\Client\Person\Model\CustomerDeleteCustomerResponse|\Openprovider\Api\Rest\Client\Person\Model\ErrorError
     */
    public function deleteCustomer($handle)
    {
        list($response) = $this->deleteCustomerWithHttpInfo($handle);
        return $response;
    }

    /**
     * Operation deleteCustomerWithHttpInfo
     *
     * Delete customer
     *
     * @param  string $handle Customer unique identifier or handle, which can be created via CreateCustomer API method (required)
     *
     * @throws Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Openprovider\Api\Rest\Client\Person\Model\CustomerDeleteCustomerResponse|\Openprovider\Api\Rest\Client\Person\Model\ErrorError, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteCustomerWithHttpInfo($handle)
    {
        $request = $this->deleteCustomerRequest($handle);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Openprovider\Api\Rest\Client\Person\Model\CustomerDeleteCustomerResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\Person\Model\CustomerDeleteCustomerResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\Openprovider\Api\Rest\Client\Person\Model\ErrorError' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\Person\Model\ErrorError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Openprovider\Api\Rest\Client\Person\Model\CustomerDeleteCustomerResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\Person\Model\CustomerDeleteCustomerResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\Person\Model\ErrorError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteCustomerAsync
     *
     * Delete customer
     *
     * @param  string $handle Customer unique identifier or handle, which can be created via CreateCustomer API method (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteCustomerAsync($handle)
    {
        return $this->deleteCustomerAsyncWithHttpInfo($handle)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteCustomerAsyncWithHttpInfo
     *
     * Delete customer
     *
     * @param  string $handle Customer unique identifier or handle, which can be created via CreateCustomer API method (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteCustomerAsyncWithHttpInfo($handle)
    {
        $returnType = '\Openprovider\Api\Rest\Client\Person\Model\CustomerDeleteCustomerResponse';
        $request = $this->deleteCustomerRequest($handle);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteCustomer'
     *
     * @param  string $handle Customer unique identifier or handle, which can be created via CreateCustomer API method (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function deleteCustomerRequest($handle)
    {
        // verify the required parameter 'handle' is set
        if ($handle === null || (is_array($handle) && count($handle) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $handle when calling deleteCustomer'
            );
        }

        $resourcePath = '/v1beta/customers/{handle}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($handle !== null) {
            $resourcePath = str_replace(
                '{' . 'handle' . '}',
                ObjectSerializer::toPathValue($handle),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getCustomer
     *
     * Get customer
     *
     * @param  string $handle Customer unique identifier or handle, which can be created via CreateCustomer API method (required)
     * @param  bool $with_additional_data Retrieves objects with (1) or without (0) additional data. (optional)
     *
     * @throws \Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Openprovider\Api\Rest\Client\Person\Model\CustomerGetCustomerResponse|\Openprovider\Api\Rest\Client\Person\Model\ErrorError
     */
    public function getCustomer($handle, $with_additional_data = null)
    {
        list($response) = $this->getCustomerWithHttpInfo($handle, $with_additional_data);
        return $response;
    }

    /**
     * Operation getCustomerWithHttpInfo
     *
     * Get customer
     *
     * @param  string $handle Customer unique identifier or handle, which can be created via CreateCustomer API method (required)
     * @param  bool $with_additional_data Retrieves objects with (1) or without (0) additional data. (optional)
     *
     * @throws Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Openprovider\Api\Rest\Client\Person\Model\CustomerGetCustomerResponse|\Openprovider\Api\Rest\Client\Person\Model\ErrorError, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCustomerWithHttpInfo($handle, $with_additional_data = null)
    {
        $request = $this->getCustomerRequest($handle, $with_additional_data);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Openprovider\Api\Rest\Client\Person\Model\CustomerGetCustomerResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\Person\Model\CustomerGetCustomerResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\Openprovider\Api\Rest\Client\Person\Model\ErrorError' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\Person\Model\ErrorError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Openprovider\Api\Rest\Client\Person\Model\CustomerGetCustomerResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\Person\Model\CustomerGetCustomerResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\Person\Model\ErrorError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getCustomerAsync
     *
     * Get customer
     *
     * @param  string $handle Customer unique identifier or handle, which can be created via CreateCustomer API method (required)
     * @param  bool $with_additional_data Retrieves objects with (1) or without (0) additional data. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCustomerAsync($handle, $with_additional_data = null)
    {
        return $this->getCustomerAsyncWithHttpInfo($handle, $with_additional_data)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getCustomerAsyncWithHttpInfo
     *
     * Get customer
     *
     * @param  string $handle Customer unique identifier or handle, which can be created via CreateCustomer API method (required)
     * @param  bool $with_additional_data Retrieves objects with (1) or without (0) additional data. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCustomerAsyncWithHttpInfo($handle, $with_additional_data = null)
    {
        $returnType = '\Openprovider\Api\Rest\Client\Person\Model\CustomerGetCustomerResponse';
        $request = $this->getCustomerRequest($handle, $with_additional_data);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getCustomer'
     *
     * @param  string $handle Customer unique identifier or handle, which can be created via CreateCustomer API method (required)
     * @param  bool $with_additional_data Retrieves objects with (1) or without (0) additional data. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getCustomerRequest($handle, $with_additional_data = null)
    {
        // verify the required parameter 'handle' is set
        if ($handle === null || (is_array($handle) && count($handle) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $handle when calling getCustomer'
            );
        }

        $resourcePath = '/v1beta/customers/{handle}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($with_additional_data !== null) {
            $queryParams['with_additional_data'] = ObjectSerializer::toQueryValue($with_additional_data);
        }

        // path params
        if ($handle !== null) {
            $resourcePath = str_replace(
                '{' . 'handle' . '}',
                ObjectSerializer::toPathValue($handle),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listCustomers
     *
     * List customers
     *
     * @param  int $reseller_id Your reseller id is used by default. Other values not accepted. (optional)
     * @param  int $limit Output limit. (optional)
     * @param  int $offset Output offset. (optional)
     * @param  string $order Output ordering pattern. ASC / DESC. (optional)
     * @param  string $order_by Order output by field (i.e. first_name). (optional)
     * @param  string $email_pattern Full or partial email address. Wildcard (*) can be used. (optional)
     * @param  string $company_name_pattern Full or partial company name. Wildcard (*) can be used. (optional)
     * @param  string $last_name_pattern Full or partial last name. Wildcard (*) can be used. (optional)
     * @param  string $first_name_pattern Full or partial first name. Wildcard (*) can be used. (optional)
     * @param  string $comment_pattern Full or partial comment value. Wildcard (*) can be used. (optional)
     * @param  string $handle_pattern Full or partial handle name. Wildcard (*) can be used. (optional)
     * @param  string $pattern ull or partial first name or last name or company name or handle. Wildcard (*) can be used. (optional)
     * @param  bool $with_additional_data Retrieves objects with (1) or without (0) additional data. (optional)
     * @param  string $type Customer type: &#39;company&#39; or &#39;individual&#39;. If customer has not empty &#39;companyName&#39; than type is &#39;company&#39;, otherwise &#39;individual&#39;. (optional)
     * @param  string[] $columns Сolumns to retrieve. Possible values: &#39;firstName&#39;, &#39;prefix&#39;, &#39;initials&#39;, &#39;lastName&#39;, &#39;companyName&#39;, &#39;email&#39;, &#39;handle&#39;, &#39;id&#39;, &#39;fullName&#39;. (optional)
     *
     * @throws \Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Openprovider\Api\Rest\Client\Person\Model\CustomerListCustomersResponse|\Openprovider\Api\Rest\Client\Person\Model\ErrorError
     */
    public function listCustomers($reseller_id = null, $limit = null, $offset = null, $order = null, $order_by = null, $email_pattern = null, $company_name_pattern = null, $last_name_pattern = null, $first_name_pattern = null, $comment_pattern = null, $handle_pattern = null, $pattern = null, $with_additional_data = null, $type = null, $columns = null)
    {
        list($response) = $this->listCustomersWithHttpInfo($reseller_id, $limit, $offset, $order, $order_by, $email_pattern, $company_name_pattern, $last_name_pattern, $first_name_pattern, $comment_pattern, $handle_pattern, $pattern, $with_additional_data, $type, $columns);
        return $response;
    }

    /**
     * Operation listCustomersWithHttpInfo
     *
     * List customers
     *
     * @param  int $reseller_id Your reseller id is used by default. Other values not accepted. (optional)
     * @param  int $limit Output limit. (optional)
     * @param  int $offset Output offset. (optional)
     * @param  string $order Output ordering pattern. ASC / DESC. (optional)
     * @param  string $order_by Order output by field (i.e. first_name). (optional)
     * @param  string $email_pattern Full or partial email address. Wildcard (*) can be used. (optional)
     * @param  string $company_name_pattern Full or partial company name. Wildcard (*) can be used. (optional)
     * @param  string $last_name_pattern Full or partial last name. Wildcard (*) can be used. (optional)
     * @param  string $first_name_pattern Full or partial first name. Wildcard (*) can be used. (optional)
     * @param  string $comment_pattern Full or partial comment value. Wildcard (*) can be used. (optional)
     * @param  string $handle_pattern Full or partial handle name. Wildcard (*) can be used. (optional)
     * @param  string $pattern ull or partial first name or last name or company name or handle. Wildcard (*) can be used. (optional)
     * @param  bool $with_additional_data Retrieves objects with (1) or without (0) additional data. (optional)
     * @param  string $type Customer type: &#39;company&#39; or &#39;individual&#39;. If customer has not empty &#39;companyName&#39; than type is &#39;company&#39;, otherwise &#39;individual&#39;. (optional)
     * @param  string[] $columns Сolumns to retrieve. Possible values: &#39;firstName&#39;, &#39;prefix&#39;, &#39;initials&#39;, &#39;lastName&#39;, &#39;companyName&#39;, &#39;email&#39;, &#39;handle&#39;, &#39;id&#39;, &#39;fullName&#39;. (optional)
     *
     * @throws Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Openprovider\Api\Rest\Client\Person\Model\CustomerListCustomersResponse|\Openprovider\Api\Rest\Client\Person\Model\ErrorError, HTTP status code, HTTP response headers (array of strings)
     */
    public function listCustomersWithHttpInfo($reseller_id = null, $limit = null, $offset = null, $order = null, $order_by = null, $email_pattern = null, $company_name_pattern = null, $last_name_pattern = null, $first_name_pattern = null, $comment_pattern = null, $handle_pattern = null, $pattern = null, $with_additional_data = null, $type = null, $columns = null)
    {
        $request = $this->listCustomersRequest($reseller_id, $limit, $offset, $order, $order_by, $email_pattern, $company_name_pattern, $last_name_pattern, $first_name_pattern, $comment_pattern, $handle_pattern, $pattern, $with_additional_data, $type, $columns);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Openprovider\Api\Rest\Client\Person\Model\CustomerListCustomersResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\Person\Model\CustomerListCustomersResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\Openprovider\Api\Rest\Client\Person\Model\ErrorError' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\Person\Model\ErrorError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Openprovider\Api\Rest\Client\Person\Model\CustomerListCustomersResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\Person\Model\CustomerListCustomersResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\Person\Model\ErrorError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listCustomersAsync
     *
     * List customers
     *
     * @param  int $reseller_id Your reseller id is used by default. Other values not accepted. (optional)
     * @param  int $limit Output limit. (optional)
     * @param  int $offset Output offset. (optional)
     * @param  string $order Output ordering pattern. ASC / DESC. (optional)
     * @param  string $order_by Order output by field (i.e. first_name). (optional)
     * @param  string $email_pattern Full or partial email address. Wildcard (*) can be used. (optional)
     * @param  string $company_name_pattern Full or partial company name. Wildcard (*) can be used. (optional)
     * @param  string $last_name_pattern Full or partial last name. Wildcard (*) can be used. (optional)
     * @param  string $first_name_pattern Full or partial first name. Wildcard (*) can be used. (optional)
     * @param  string $comment_pattern Full or partial comment value. Wildcard (*) can be used. (optional)
     * @param  string $handle_pattern Full or partial handle name. Wildcard (*) can be used. (optional)
     * @param  string $pattern ull or partial first name or last name or company name or handle. Wildcard (*) can be used. (optional)
     * @param  bool $with_additional_data Retrieves objects with (1) or without (0) additional data. (optional)
     * @param  string $type Customer type: &#39;company&#39; or &#39;individual&#39;. If customer has not empty &#39;companyName&#39; than type is &#39;company&#39;, otherwise &#39;individual&#39;. (optional)
     * @param  string[] $columns Сolumns to retrieve. Possible values: &#39;firstName&#39;, &#39;prefix&#39;, &#39;initials&#39;, &#39;lastName&#39;, &#39;companyName&#39;, &#39;email&#39;, &#39;handle&#39;, &#39;id&#39;, &#39;fullName&#39;. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listCustomersAsync($reseller_id = null, $limit = null, $offset = null, $order = null, $order_by = null, $email_pattern = null, $company_name_pattern = null, $last_name_pattern = null, $first_name_pattern = null, $comment_pattern = null, $handle_pattern = null, $pattern = null, $with_additional_data = null, $type = null, $columns = null)
    {
        return $this->listCustomersAsyncWithHttpInfo($reseller_id, $limit, $offset, $order, $order_by, $email_pattern, $company_name_pattern, $last_name_pattern, $first_name_pattern, $comment_pattern, $handle_pattern, $pattern, $with_additional_data, $type, $columns)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listCustomersAsyncWithHttpInfo
     *
     * List customers
     *
     * @param  int $reseller_id Your reseller id is used by default. Other values not accepted. (optional)
     * @param  int $limit Output limit. (optional)
     * @param  int $offset Output offset. (optional)
     * @param  string $order Output ordering pattern. ASC / DESC. (optional)
     * @param  string $order_by Order output by field (i.e. first_name). (optional)
     * @param  string $email_pattern Full or partial email address. Wildcard (*) can be used. (optional)
     * @param  string $company_name_pattern Full or partial company name. Wildcard (*) can be used. (optional)
     * @param  string $last_name_pattern Full or partial last name. Wildcard (*) can be used. (optional)
     * @param  string $first_name_pattern Full or partial first name. Wildcard (*) can be used. (optional)
     * @param  string $comment_pattern Full or partial comment value. Wildcard (*) can be used. (optional)
     * @param  string $handle_pattern Full or partial handle name. Wildcard (*) can be used. (optional)
     * @param  string $pattern ull or partial first name or last name or company name or handle. Wildcard (*) can be used. (optional)
     * @param  bool $with_additional_data Retrieves objects with (1) or without (0) additional data. (optional)
     * @param  string $type Customer type: &#39;company&#39; or &#39;individual&#39;. If customer has not empty &#39;companyName&#39; than type is &#39;company&#39;, otherwise &#39;individual&#39;. (optional)
     * @param  string[] $columns Сolumns to retrieve. Possible values: &#39;firstName&#39;, &#39;prefix&#39;, &#39;initials&#39;, &#39;lastName&#39;, &#39;companyName&#39;, &#39;email&#39;, &#39;handle&#39;, &#39;id&#39;, &#39;fullName&#39;. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listCustomersAsyncWithHttpInfo($reseller_id = null, $limit = null, $offset = null, $order = null, $order_by = null, $email_pattern = null, $company_name_pattern = null, $last_name_pattern = null, $first_name_pattern = null, $comment_pattern = null, $handle_pattern = null, $pattern = null, $with_additional_data = null, $type = null, $columns = null)
    {
        $returnType = '\Openprovider\Api\Rest\Client\Person\Model\CustomerListCustomersResponse';
        $request = $this->listCustomersRequest($reseller_id, $limit, $offset, $order, $order_by, $email_pattern, $company_name_pattern, $last_name_pattern, $first_name_pattern, $comment_pattern, $handle_pattern, $pattern, $with_additional_data, $type, $columns);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listCustomers'
     *
     * @param  int $reseller_id Your reseller id is used by default. Other values not accepted. (optional)
     * @param  int $limit Output limit. (optional)
     * @param  int $offset Output offset. (optional)
     * @param  string $order Output ordering pattern. ASC / DESC. (optional)
     * @param  string $order_by Order output by field (i.e. first_name). (optional)
     * @param  string $email_pattern Full or partial email address. Wildcard (*) can be used. (optional)
     * @param  string $company_name_pattern Full or partial company name. Wildcard (*) can be used. (optional)
     * @param  string $last_name_pattern Full or partial last name. Wildcard (*) can be used. (optional)
     * @param  string $first_name_pattern Full or partial first name. Wildcard (*) can be used. (optional)
     * @param  string $comment_pattern Full or partial comment value. Wildcard (*) can be used. (optional)
     * @param  string $handle_pattern Full or partial handle name. Wildcard (*) can be used. (optional)
     * @param  string $pattern ull or partial first name or last name or company name or handle. Wildcard (*) can be used. (optional)
     * @param  bool $with_additional_data Retrieves objects with (1) or without (0) additional data. (optional)
     * @param  string $type Customer type: &#39;company&#39; or &#39;individual&#39;. If customer has not empty &#39;companyName&#39; than type is &#39;company&#39;, otherwise &#39;individual&#39;. (optional)
     * @param  string[] $columns Сolumns to retrieve. Possible values: &#39;firstName&#39;, &#39;prefix&#39;, &#39;initials&#39;, &#39;lastName&#39;, &#39;companyName&#39;, &#39;email&#39;, &#39;handle&#39;, &#39;id&#39;, &#39;fullName&#39;. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function listCustomersRequest($reseller_id = null, $limit = null, $offset = null, $order = null, $order_by = null, $email_pattern = null, $company_name_pattern = null, $last_name_pattern = null, $first_name_pattern = null, $comment_pattern = null, $handle_pattern = null, $pattern = null, $with_additional_data = null, $type = null, $columns = null)
    {

        $resourcePath = '/v1beta/customers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($reseller_id !== null) {
            $queryParams['reseller_id'] = ObjectSerializer::toQueryValue($reseller_id);
        }
        // query params
        if ($limit !== null) {
            $queryParams['limit'] = ObjectSerializer::toQueryValue($limit);
        }
        // query params
        if ($offset !== null) {
            $queryParams['offset'] = ObjectSerializer::toQueryValue($offset);
        }
        // query params
        if ($order !== null) {
            $queryParams['order'] = ObjectSerializer::toQueryValue($order);
        }
        // query params
        if ($order_by !== null) {
            $queryParams['order_by'] = ObjectSerializer::toQueryValue($order_by);
        }
        // query params
        if ($email_pattern !== null) {
            $queryParams['email_pattern'] = ObjectSerializer::toQueryValue($email_pattern);
        }
        // query params
        if ($company_name_pattern !== null) {
            $queryParams['company_name_pattern'] = ObjectSerializer::toQueryValue($company_name_pattern);
        }
        // query params
        if ($last_name_pattern !== null) {
            $queryParams['last_name_pattern'] = ObjectSerializer::toQueryValue($last_name_pattern);
        }
        // query params
        if ($first_name_pattern !== null) {
            $queryParams['first_name_pattern'] = ObjectSerializer::toQueryValue($first_name_pattern);
        }
        // query params
        if ($comment_pattern !== null) {
            $queryParams['comment_pattern'] = ObjectSerializer::toQueryValue($comment_pattern);
        }
        // query params
        if ($handle_pattern !== null) {
            $queryParams['handle_pattern'] = ObjectSerializer::toQueryValue($handle_pattern);
        }
        // query params
        if ($pattern !== null) {
            $queryParams['pattern'] = ObjectSerializer::toQueryValue($pattern);
        }
        // query params
        if ($with_additional_data !== null) {
            $queryParams['with_additional_data'] = ObjectSerializer::toQueryValue($with_additional_data);
        }
        // query params
        if ($type !== null) {
            $queryParams['type'] = ObjectSerializer::toQueryValue($type);
        }
        // query params
        if (is_array($columns)) {
            $columns = ObjectSerializer::serializeCollection($columns, 'multi', true);
        }
        if ($columns !== null) {
            $queryParams['columns'] = ObjectSerializer::toQueryValue($columns);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateCustomer
     *
     * Update customer
     *
     * @param  string $handle Customer unique identifier or handle, which can be created via CreateCustomer API method (required)
     * @param  \Openprovider\Api\Rest\Client\Person\Model\CustomerUpdateCustomerRequest $body body (required)
     *
     * @throws \Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Openprovider\Api\Rest\Client\Person\Model\CustomerUpdateCustomerResponse|\Openprovider\Api\Rest\Client\Person\Model\ErrorError
     */
    public function updateCustomer($handle, $body)
    {
        list($response) = $this->updateCustomerWithHttpInfo($handle, $body);
        return $response;
    }

    /**
     * Operation updateCustomerWithHttpInfo
     *
     * Update customer
     *
     * @param  string $handle Customer unique identifier or handle, which can be created via CreateCustomer API method (required)
     * @param  \Openprovider\Api\Rest\Client\Person\Model\CustomerUpdateCustomerRequest $body (required)
     *
     * @throws Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Openprovider\Api\Rest\Client\Person\Model\CustomerUpdateCustomerResponse|\Openprovider\Api\Rest\Client\Person\Model\ErrorError, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateCustomerWithHttpInfo($handle, $body)
    {
        $request = $this->updateCustomerRequest($handle, $body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Openprovider\Api\Rest\Client\Person\Model\CustomerUpdateCustomerResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\Person\Model\CustomerUpdateCustomerResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\Openprovider\Api\Rest\Client\Person\Model\ErrorError' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\Person\Model\ErrorError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Openprovider\Api\Rest\Client\Person\Model\CustomerUpdateCustomerResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\Person\Model\CustomerUpdateCustomerResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\Person\Model\ErrorError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateCustomerAsync
     *
     * Update customer
     *
     * @param  string $handle Customer unique identifier or handle, which can be created via CreateCustomer API method (required)
     * @param  \Openprovider\Api\Rest\Client\Person\Model\CustomerUpdateCustomerRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateCustomerAsync($handle, $body)
    {
        return $this->updateCustomerAsyncWithHttpInfo($handle, $body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateCustomerAsyncWithHttpInfo
     *
     * Update customer
     *
     * @param  string $handle Customer unique identifier or handle, which can be created via CreateCustomer API method (required)
     * @param  \Openprovider\Api\Rest\Client\Person\Model\CustomerUpdateCustomerRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateCustomerAsyncWithHttpInfo($handle, $body)
    {
        $returnType = '\Openprovider\Api\Rest\Client\Person\Model\CustomerUpdateCustomerResponse';
        $request = $this->updateCustomerRequest($handle, $body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateCustomer'
     *
     * @param  string $handle Customer unique identifier or handle, which can be created via CreateCustomer API method (required)
     * @param  \Openprovider\Api\Rest\Client\Person\Model\CustomerUpdateCustomerRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function updateCustomerRequest($handle, $body)
    {
        // verify the required parameter 'handle' is set
        if ($handle === null || (is_array($handle) && count($handle) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $handle when calling updateCustomer'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling updateCustomer'
            );
        }

        $resourcePath = '/v1beta/customers/{handle}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($handle !== null) {
            $resourcePath = str_replace(
                '{' . 'handle' . '}',
                ObjectSerializer::toPathValue($handle),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
