<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\IpMessaging\V2;

use Twilio\Options;
use Twilio\Values;

abstract class ServiceOptions {
    /**
     * @param string $friendlyName The friendly_name
     * @param string $defaultServiceRoleSid The default_service_role_sid
     * @param string $defaultChannelRoleSid The default_channel_role_sid
     * @param string $defaultChannelCreatorRoleSid The
     *                                             default_channel_creator_role_sid
     * @param bool $readStatusEnabled The read_status_enabled
     * @param bool $reachabilityEnabled The reachability_enabled
     * @param int $typingIndicatorTimeout The typing_indicator_timeout
     * @param int $consumptionReportInterval The consumption_report_interval
     * @param bool $notificationsNewMessageEnabled The
     *                                             notifications.new_message.enabled
     * @param string $notificationsNewMessageTemplate The
     *                                                notifications.new_message.template
     * @param string $notificationsNewMessageSound The
     *                                             notifications.new_message.sound
     * @param bool $notificationsNewMessageBadgeCountEnabled The
     *                                                       notifications.new_message.badge_count_enabled
     * @param bool $notificationsAddedToChannelEnabled The
     *                                                 notifications.added_to_channel.enabled
     * @param string $notificationsAddedToChannelTemplate The
     *                                                    notifications.added_to_channel.template
     * @param string $notificationsAddedToChannelSound The
     *                                                 notifications.added_to_channel.sound
     * @param bool $notificationsRemovedFromChannelEnabled The
     *                                                     notifications.removed_from_channel.enabled
     * @param string $notificationsRemovedFromChannelTemplate The
     *                                                        notifications.removed_from_channel.template
     * @param string $notificationsRemovedFromChannelSound The
     *                                                     notifications.removed_from_channel.sound
     * @param bool $notificationsInvitedToChannelEnabled The
     *                                                   notifications.invited_to_channel.enabled
     * @param string $notificationsInvitedToChannelTemplate The
     *                                                      notifications.invited_to_channel.template
     * @param string $notificationsInvitedToChannelSound The
     *                                                   notifications.invited_to_channel.sound
     * @param string $preWebhookUrl The pre_webhook_url
     * @param string $postWebhookUrl The post_webhook_url
     * @param string $webhookMethod The webhook_method
     * @param string[] $webhookFilters The webhook_filters
     * @param int $limitsChannelMembers The limits.channel_members
     * @param int $limitsUserChannels The limits.user_channels
     * @param string $mediaCompatibilityMessage The media.compatibility_message
     * @param int $preWebhookRetryCount The pre_webhook_retry_count
     * @param int $postWebhookRetryCount The post_webhook_retry_count
     * @param bool $notificationsLogEnabled The notifications.log_enabled
     * @return UpdateServiceOptions Options builder
     */
    public static function update(string $friendlyName = Values::NONE, string $defaultServiceRoleSid = Values::NONE, string $defaultChannelRoleSid = Values::NONE, string $defaultChannelCreatorRoleSid = Values::NONE, bool $readStatusEnabled = Values::NONE, bool $reachabilityEnabled = Values::NONE, int $typingIndicatorTimeout = Values::NONE, int $consumptionReportInterval = Values::NONE, bool $notificationsNewMessageEnabled = Values::NONE, string $notificationsNewMessageTemplate = Values::NONE, string $notificationsNewMessageSound = Values::NONE, bool $notificationsNewMessageBadgeCountEnabled = Values::NONE, bool $notificationsAddedToChannelEnabled = Values::NONE, string $notificationsAddedToChannelTemplate = Values::NONE, string $notificationsAddedToChannelSound = Values::NONE, bool $notificationsRemovedFromChannelEnabled = Values::NONE, string $notificationsRemovedFromChannelTemplate = Values::NONE, string $notificationsRemovedFromChannelSound = Values::NONE, bool $notificationsInvitedToChannelEnabled = Values::NONE, string $notificationsInvitedToChannelTemplate = Values::NONE, string $notificationsInvitedToChannelSound = Values::NONE, string $preWebhookUrl = Values::NONE, string $postWebhookUrl = Values::NONE, string $webhookMethod = Values::NONE, array $webhookFilters = Values::ARRAY_NONE, int $limitsChannelMembers = Values::NONE, int $limitsUserChannels = Values::NONE, string $mediaCompatibilityMessage = Values::NONE, int $preWebhookRetryCount = Values::NONE, int $postWebhookRetryCount = Values::NONE, bool $notificationsLogEnabled = Values::NONE): UpdateServiceOptions {
        return new UpdateServiceOptions($friendlyName, $defaultServiceRoleSid, $defaultChannelRoleSid, $defaultChannelCreatorRoleSid, $readStatusEnabled, $reachabilityEnabled, $typingIndicatorTimeout, $consumptionReportInterval, $notificationsNewMessageEnabled, $notificationsNewMessageTemplate, $notificationsNewMessageSound, $notificationsNewMessageBadgeCountEnabled, $notificationsAddedToChannelEnabled, $notificationsAddedToChannelTemplate, $notificationsAddedToChannelSound, $notificationsRemovedFromChannelEnabled, $notificationsRemovedFromChannelTemplate, $notificationsRemovedFromChannelSound, $notificationsInvitedToChannelEnabled, $notificationsInvitedToChannelTemplate, $notificationsInvitedToChannelSound, $preWebhookUrl, $postWebhookUrl, $webhookMethod, $webhookFilters, $limitsChannelMembers, $limitsUserChannels, $mediaCompatibilityMessage, $preWebhookRetryCount, $postWebhookRetryCount, $notificationsLogEnabled);
    }
}

class UpdateServiceOptions extends Options {
    /**
     * @param string $friendlyName The friendly_name
     * @param string $defaultServiceRoleSid The default_service_role_sid
     * @param string $defaultChannelRoleSid The default_channel_role_sid
     * @param string $defaultChannelCreatorRoleSid The
     *                                             default_channel_creator_role_sid
     * @param bool $readStatusEnabled The read_status_enabled
     * @param bool $reachabilityEnabled The reachability_enabled
     * @param int $typingIndicatorTimeout The typing_indicator_timeout
     * @param int $consumptionReportInterval The consumption_report_interval
     * @param bool $notificationsNewMessageEnabled The
     *                                             notifications.new_message.enabled
     * @param string $notificationsNewMessageTemplate The
     *                                                notifications.new_message.template
     * @param string $notificationsNewMessageSound The
     *                                             notifications.new_message.sound
     * @param bool $notificationsNewMessageBadgeCountEnabled The
     *                                                       notifications.new_message.badge_count_enabled
     * @param bool $notificationsAddedToChannelEnabled The
     *                                                 notifications.added_to_channel.enabled
     * @param string $notificationsAddedToChannelTemplate The
     *                                                    notifications.added_to_channel.template
     * @param string $notificationsAddedToChannelSound The
     *                                                 notifications.added_to_channel.sound
     * @param bool $notificationsRemovedFromChannelEnabled The
     *                                                     notifications.removed_from_channel.enabled
     * @param string $notificationsRemovedFromChannelTemplate The
     *                                                        notifications.removed_from_channel.template
     * @param string $notificationsRemovedFromChannelSound The
     *                                                     notifications.removed_from_channel.sound
     * @param bool $notificationsInvitedToChannelEnabled The
     *                                                   notifications.invited_to_channel.enabled
     * @param string $notificationsInvitedToChannelTemplate The
     *                                                      notifications.invited_to_channel.template
     * @param string $notificationsInvitedToChannelSound The
     *                                                   notifications.invited_to_channel.sound
     * @param string $preWebhookUrl The pre_webhook_url
     * @param string $postWebhookUrl The post_webhook_url
     * @param string $webhookMethod The webhook_method
     * @param string[] $webhookFilters The webhook_filters
     * @param int $limitsChannelMembers The limits.channel_members
     * @param int $limitsUserChannels The limits.user_channels
     * @param string $mediaCompatibilityMessage The media.compatibility_message
     * @param int $preWebhookRetryCount The pre_webhook_retry_count
     * @param int $postWebhookRetryCount The post_webhook_retry_count
     * @param bool $notificationsLogEnabled The notifications.log_enabled
     */
    public function __construct(string $friendlyName = Values::NONE, string $defaultServiceRoleSid = Values::NONE, string $defaultChannelRoleSid = Values::NONE, string $defaultChannelCreatorRoleSid = Values::NONE, bool $readStatusEnabled = Values::NONE, bool $reachabilityEnabled = Values::NONE, int $typingIndicatorTimeout = Values::NONE, int $consumptionReportInterval = Values::NONE, bool $notificationsNewMessageEnabled = Values::NONE, string $notificationsNewMessageTemplate = Values::NONE, string $notificationsNewMessageSound = Values::NONE, bool $notificationsNewMessageBadgeCountEnabled = Values::NONE, bool $notificationsAddedToChannelEnabled = Values::NONE, string $notificationsAddedToChannelTemplate = Values::NONE, string $notificationsAddedToChannelSound = Values::NONE, bool $notificationsRemovedFromChannelEnabled = Values::NONE, string $notificationsRemovedFromChannelTemplate = Values::NONE, string $notificationsRemovedFromChannelSound = Values::NONE, bool $notificationsInvitedToChannelEnabled = Values::NONE, string $notificationsInvitedToChannelTemplate = Values::NONE, string $notificationsInvitedToChannelSound = Values::NONE, string $preWebhookUrl = Values::NONE, string $postWebhookUrl = Values::NONE, string $webhookMethod = Values::NONE, array $webhookFilters = Values::ARRAY_NONE, int $limitsChannelMembers = Values::NONE, int $limitsUserChannels = Values::NONE, string $mediaCompatibilityMessage = Values::NONE, int $preWebhookRetryCount = Values::NONE, int $postWebhookRetryCount = Values::NONE, bool $notificationsLogEnabled = Values::NONE) {
        $this->options['friendlyName'] = $friendlyName;
        $this->options['defaultServiceRoleSid'] = $defaultServiceRoleSid;
        $this->options['defaultChannelRoleSid'] = $defaultChannelRoleSid;
        $this->options['defaultChannelCreatorRoleSid'] = $defaultChannelCreatorRoleSid;
        $this->options['readStatusEnabled'] = $readStatusEnabled;
        $this->options['reachabilityEnabled'] = $reachabilityEnabled;
        $this->options['typingIndicatorTimeout'] = $typingIndicatorTimeout;
        $this->options['consumptionReportInterval'] = $consumptionReportInterval;
        $this->options['notificationsNewMessageEnabled'] = $notificationsNewMessageEnabled;
        $this->options['notificationsNewMessageTemplate'] = $notificationsNewMessageTemplate;
        $this->options['notificationsNewMessageSound'] = $notificationsNewMessageSound;
        $this->options['notificationsNewMessageBadgeCountEnabled'] = $notificationsNewMessageBadgeCountEnabled;
        $this->options['notificationsAddedToChannelEnabled'] = $notificationsAddedToChannelEnabled;
        $this->options['notificationsAddedToChannelTemplate'] = $notificationsAddedToChannelTemplate;
        $this->options['notificationsAddedToChannelSound'] = $notificationsAddedToChannelSound;
        $this->options['notificationsRemovedFromChannelEnabled'] = $notificationsRemovedFromChannelEnabled;
        $this->options['notificationsRemovedFromChannelTemplate'] = $notificationsRemovedFromChannelTemplate;
        $this->options['notificationsRemovedFromChannelSound'] = $notificationsRemovedFromChannelSound;
        $this->options['notificationsInvitedToChannelEnabled'] = $notificationsInvitedToChannelEnabled;
        $this->options['notificationsInvitedToChannelTemplate'] = $notificationsInvitedToChannelTemplate;
        $this->options['notificationsInvitedToChannelSound'] = $notificationsInvitedToChannelSound;
        $this->options['preWebhookUrl'] = $preWebhookUrl;
        $this->options['postWebhookUrl'] = $postWebhookUrl;
        $this->options['webhookMethod'] = $webhookMethod;
        $this->options['webhookFilters'] = $webhookFilters;
        $this->options['limitsChannelMembers'] = $limitsChannelMembers;
        $this->options['limitsUserChannels'] = $limitsUserChannels;
        $this->options['mediaCompatibilityMessage'] = $mediaCompatibilityMessage;
        $this->options['preWebhookRetryCount'] = $preWebhookRetryCount;
        $this->options['postWebhookRetryCount'] = $postWebhookRetryCount;
        $this->options['notificationsLogEnabled'] = $notificationsLogEnabled;
    }

    /**
     * The friendly_name
     *
     * @param string $friendlyName The friendly_name
     * @return $this Fluent Builder
     */
    public function setFriendlyName(string $friendlyName): self {
        $this->options['friendlyName'] = $friendlyName;
        return $this;
    }

    /**
     * The default_service_role_sid
     *
     * @param string $defaultServiceRoleSid The default_service_role_sid
     * @return $this Fluent Builder
     */
    public function setDefaultServiceRoleSid(string $defaultServiceRoleSid): self {
        $this->options['defaultServiceRoleSid'] = $defaultServiceRoleSid;
        return $this;
    }

    /**
     * The default_channel_role_sid
     *
     * @param string $defaultChannelRoleSid The default_channel_role_sid
     * @return $this Fluent Builder
     */
    public function setDefaultChannelRoleSid(string $defaultChannelRoleSid): self {
        $this->options['defaultChannelRoleSid'] = $defaultChannelRoleSid;
        return $this;
    }

    /**
     * The default_channel_creator_role_sid
     *
     * @param string $defaultChannelCreatorRoleSid The
     *                                             default_channel_creator_role_sid
     * @return $this Fluent Builder
     */
    public function setDefaultChannelCreatorRoleSid(string $defaultChannelCreatorRoleSid): self {
        $this->options['defaultChannelCreatorRoleSid'] = $defaultChannelCreatorRoleSid;
        return $this;
    }

    /**
     * The read_status_enabled
     *
     * @param bool $readStatusEnabled The read_status_enabled
     * @return $this Fluent Builder
     */
    public function setReadStatusEnabled(bool $readStatusEnabled): self {
        $this->options['readStatusEnabled'] = $readStatusEnabled;
        return $this;
    }

    /**
     * The reachability_enabled
     *
     * @param bool $reachabilityEnabled The reachability_enabled
     * @return $this Fluent Builder
     */
    public function setReachabilityEnabled(bool $reachabilityEnabled): self {
        $this->options['reachabilityEnabled'] = $reachabilityEnabled;
        return $this;
    }

    /**
     * The typing_indicator_timeout
     *
     * @param int $typingIndicatorTimeout The typing_indicator_timeout
     * @return $this Fluent Builder
     */
    public function setTypingIndicatorTimeout(int $typingIndicatorTimeout): self {
        $this->options['typingIndicatorTimeout'] = $typingIndicatorTimeout;
        return $this;
    }

    /**
     * The consumption_report_interval
     *
     * @param int $consumptionReportInterval The consumption_report_interval
     * @return $this Fluent Builder
     */
    public function setConsumptionReportInterval(int $consumptionReportInterval): self {
        $this->options['consumptionReportInterval'] = $consumptionReportInterval;
        return $this;
    }

    /**
     * The notifications.new_message.enabled
     *
     * @param bool $notificationsNewMessageEnabled The
     *                                             notifications.new_message.enabled
     * @return $this Fluent Builder
     */
    public function setNotificationsNewMessageEnabled(bool $notificationsNewMessageEnabled): self {
        $this->options['notificationsNewMessageEnabled'] = $notificationsNewMessageEnabled;
        return $this;
    }

    /**
     * The notifications.new_message.template
     *
     * @param string $notificationsNewMessageTemplate The
     *                                                notifications.new_message.template
     * @return $this Fluent Builder
     */
    public function setNotificationsNewMessageTemplate(string $notificationsNewMessageTemplate): self {
        $this->options['notificationsNewMessageTemplate'] = $notificationsNewMessageTemplate;
        return $this;
    }

    /**
     * The notifications.new_message.sound
     *
     * @param string $notificationsNewMessageSound The
     *                                             notifications.new_message.sound
     * @return $this Fluent Builder
     */
    public function setNotificationsNewMessageSound(string $notificationsNewMessageSound): self {
        $this->options['notificationsNewMessageSound'] = $notificationsNewMessageSound;
        return $this;
    }

    /**
     * The notifications.new_message.badge_count_enabled
     *
     * @param bool $notificationsNewMessageBadgeCountEnabled The
     *                                                       notifications.new_message.badge_count_enabled
     * @return $this Fluent Builder
     */
    public function setNotificationsNewMessageBadgeCountEnabled(bool $notificationsNewMessageBadgeCountEnabled): self {
        $this->options['notificationsNewMessageBadgeCountEnabled'] = $notificationsNewMessageBadgeCountEnabled;
        return $this;
    }

    /**
     * The notifications.added_to_channel.enabled
     *
     * @param bool $notificationsAddedToChannelEnabled The
     *                                                 notifications.added_to_channel.enabled
     * @return $this Fluent Builder
     */
    public function setNotificationsAddedToChannelEnabled(bool $notificationsAddedToChannelEnabled): self {
        $this->options['notificationsAddedToChannelEnabled'] = $notificationsAddedToChannelEnabled;
        return $this;
    }

    /**
     * The notifications.added_to_channel.template
     *
     * @param string $notificationsAddedToChannelTemplate The
     *                                                    notifications.added_to_channel.template
     * @return $this Fluent Builder
     */
    public function setNotificationsAddedToChannelTemplate(string $notificationsAddedToChannelTemplate): self {
        $this->options['notificationsAddedToChannelTemplate'] = $notificationsAddedToChannelTemplate;
        return $this;
    }

    /**
     * The notifications.added_to_channel.sound
     *
     * @param string $notificationsAddedToChannelSound The
     *                                                 notifications.added_to_channel.sound
     * @return $this Fluent Builder
     */
    public function setNotificationsAddedToChannelSound(string $notificationsAddedToChannelSound): self {
        $this->options['notificationsAddedToChannelSound'] = $notificationsAddedToChannelSound;
        return $this;
    }

    /**
     * The notifications.removed_from_channel.enabled
     *
     * @param bool $notificationsRemovedFromChannelEnabled The
     *                                                     notifications.removed_from_channel.enabled
     * @return $this Fluent Builder
     */
    public function setNotificationsRemovedFromChannelEnabled(bool $notificationsRemovedFromChannelEnabled): self {
        $this->options['notificationsRemovedFromChannelEnabled'] = $notificationsRemovedFromChannelEnabled;
        return $this;
    }

    /**
     * The notifications.removed_from_channel.template
     *
     * @param string $notificationsRemovedFromChannelTemplate The
     *                                                        notifications.removed_from_channel.template
     * @return $this Fluent Builder
     */
    public function setNotificationsRemovedFromChannelTemplate(string $notificationsRemovedFromChannelTemplate): self {
        $this->options['notificationsRemovedFromChannelTemplate'] = $notificationsRemovedFromChannelTemplate;
        return $this;
    }

    /**
     * The notifications.removed_from_channel.sound
     *
     * @param string $notificationsRemovedFromChannelSound The
     *                                                     notifications.removed_from_channel.sound
     * @return $this Fluent Builder
     */
    public function setNotificationsRemovedFromChannelSound(string $notificationsRemovedFromChannelSound): self {
        $this->options['notificationsRemovedFromChannelSound'] = $notificationsRemovedFromChannelSound;
        return $this;
    }

    /**
     * The notifications.invited_to_channel.enabled
     *
     * @param bool $notificationsInvitedToChannelEnabled The
     *                                                   notifications.invited_to_channel.enabled
     * @return $this Fluent Builder
     */
    public function setNotificationsInvitedToChannelEnabled(bool $notificationsInvitedToChannelEnabled): self {
        $this->options['notificationsInvitedToChannelEnabled'] = $notificationsInvitedToChannelEnabled;
        return $this;
    }

    /**
     * The notifications.invited_to_channel.template
     *
     * @param string $notificationsInvitedToChannelTemplate The
     *                                                      notifications.invited_to_channel.template
     * @return $this Fluent Builder
     */
    public function setNotificationsInvitedToChannelTemplate(string $notificationsInvitedToChannelTemplate): self {
        $this->options['notificationsInvitedToChannelTemplate'] = $notificationsInvitedToChannelTemplate;
        return $this;
    }

    /**
     * The notifications.invited_to_channel.sound
     *
     * @param string $notificationsInvitedToChannelSound The
     *                                                   notifications.invited_to_channel.sound
     * @return $this Fluent Builder
     */
    public function setNotificationsInvitedToChannelSound(string $notificationsInvitedToChannelSound): self {
        $this->options['notificationsInvitedToChannelSound'] = $notificationsInvitedToChannelSound;
        return $this;
    }

    /**
     * The pre_webhook_url
     *
     * @param string $preWebhookUrl The pre_webhook_url
     * @return $this Fluent Builder
     */
    public function setPreWebhookUrl(string $preWebhookUrl): self {
        $this->options['preWebhookUrl'] = $preWebhookUrl;
        return $this;
    }

    /**
     * The post_webhook_url
     *
     * @param string $postWebhookUrl The post_webhook_url
     * @return $this Fluent Builder
     */
    public function setPostWebhookUrl(string $postWebhookUrl): self {
        $this->options['postWebhookUrl'] = $postWebhookUrl;
        return $this;
    }

    /**
     * The webhook_method
     *
     * @param string $webhookMethod The webhook_method
     * @return $this Fluent Builder
     */
    public function setWebhookMethod(string $webhookMethod): self {
        $this->options['webhookMethod'] = $webhookMethod;
        return $this;
    }

    /**
     * The webhook_filters
     *
     * @param string[] $webhookFilters The webhook_filters
     * @return $this Fluent Builder
     */
    public function setWebhookFilters(array $webhookFilters): self {
        $this->options['webhookFilters'] = $webhookFilters;
        return $this;
    }

    /**
     * The limits.channel_members
     *
     * @param int $limitsChannelMembers The limits.channel_members
     * @return $this Fluent Builder
     */
    public function setLimitsChannelMembers(int $limitsChannelMembers): self {
        $this->options['limitsChannelMembers'] = $limitsChannelMembers;
        return $this;
    }

    /**
     * The limits.user_channels
     *
     * @param int $limitsUserChannels The limits.user_channels
     * @return $this Fluent Builder
     */
    public function setLimitsUserChannels(int $limitsUserChannels): self {
        $this->options['limitsUserChannels'] = $limitsUserChannels;
        return $this;
    }

    /**
     * The media.compatibility_message
     *
     * @param string $mediaCompatibilityMessage The media.compatibility_message
     * @return $this Fluent Builder
     */
    public function setMediaCompatibilityMessage(string $mediaCompatibilityMessage): self {
        $this->options['mediaCompatibilityMessage'] = $mediaCompatibilityMessage;
        return $this;
    }

    /**
     * The pre_webhook_retry_count
     *
     * @param int $preWebhookRetryCount The pre_webhook_retry_count
     * @return $this Fluent Builder
     */
    public function setPreWebhookRetryCount(int $preWebhookRetryCount): self {
        $this->options['preWebhookRetryCount'] = $preWebhookRetryCount;
        return $this;
    }

    /**
     * The post_webhook_retry_count
     *
     * @param int $postWebhookRetryCount The post_webhook_retry_count
     * @return $this Fluent Builder
     */
    public function setPostWebhookRetryCount(int $postWebhookRetryCount): self {
        $this->options['postWebhookRetryCount'] = $postWebhookRetryCount;
        return $this;
    }

    /**
     * The notifications.log_enabled
     *
     * @param bool $notificationsLogEnabled The notifications.log_enabled
     * @return $this Fluent Builder
     */
    public function setNotificationsLogEnabled(bool $notificationsLogEnabled): self {
        $this->options['notificationsLogEnabled'] = $notificationsLogEnabled;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.IpMessaging.V2.UpdateServiceOptions ' . $options . ']';
    }
}