<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Api\V2010\Account\Conference;

use Twilio\Options;
use Twilio\Values;

abstract class ParticipantOptions {
    /**
     * @param boolean $muted Indicates if the participant should be muted
     * @param boolean $hold Specifying true will hold the participant, while false
     *                      will un-hold.
     * @param string $holdUrl The 'HoldUrl' attribute lets you specify a URL for
     *                        music that plays when a participant is held.
     * @param string $holdMethod Specify GET or POST, defaults to GET
     * @param string $announceUrl The 'AnnounceUrl' attribute lets you specify a
     *                            URL for announcing something to the participant.
     * @param string $announceMethod Specify GET or POST, defaults to POST
     * @return UpdateParticipantOptions Options builder
     */
    public static function update($muted = Values::NONE, $hold = Values::NONE, $holdUrl = Values::NONE, $holdMethod = Values::NONE, $announceUrl = Values::NONE, $announceMethod = Values::NONE) {
        return new UpdateParticipantOptions($muted, $hold, $holdUrl, $holdMethod, $announceUrl, $announceMethod);
    }

    /**
     * @param string $statusCallback URL for conference event callback.
     * @param string $statusCallbackMethod Method Twilio should use to reach the
     *                                     status callback URL.
     * @param string $statusCallbackEvent Set state change events that will trigger
     *                                    a callback.
     * @param integer $timeout Number of seconds Twilio will wait for an answer.
     * @param boolean $record Record the agent and their conferences.
     * @param boolean $muted Mute the agent.
     * @param string $beep Play a beep when the participant joins the conference.
     * @param boolean $startConferenceOnEnter Begin the conference when the
     *                                        participant joins.
     * @param boolean $endConferenceOnExit End the conference when the participant
     *                                     leaves.
     * @param string $waitUrl URL that hosts pre-conference hold music
     * @param string $waitMethod The method Twilio should use to request `WaitUrl`.
     * @param boolean $earlyMedia Agents can hear the state of the outbound call.
     * @param integer $maxParticipants Maximum number of agent conference
     *                                 participants.
     * @param string $conferenceRecord Record the conference.
     * @param string $conferenceTrim Trim silence from audio files.
     * @param string $conferenceStatusCallback Callback URL for conference events.
     * @param string $conferenceStatusCallbackMethod HTTP method for requesting
     *                                               `ConferenceStatusCallback` URL.
     * @param string $conferenceStatusCallbackEvent Set which conference state
     *                                              changes should webhook to the
     *                                              `ConferenceStatusCallback`
     * @param string $recordingChannels Specify `mono` or `dual` recording channels.
     * @param string $recordingStatusCallback The absolute URL for Twilio's webhook
     *                                        with recording status information.
     * @param string $recordingStatusCallbackMethod HTTP method for
     *                                              `RecordingStatusCallback`
     * @param string $sipAuthUsername SIP username used for authenticating.
     * @param string $sipAuthPassword SIP password for authentication.
     * @param string $region The region where Twilio should mix the conference
     *                       audio.
     * @param string $conferenceRecordingStatusCallback Conference recording
     *                                                  callback URL.
     * @param string $conferenceRecordingStatusCallbackMethod Method Twilio should
     *                                                        use to request the
     *                                                        `ConferenceRecordingStatusCallback` URL.
     * @param string $recordingStatusCallbackEvent Set which recording state
     *                                             changes should webhook to the
     *                                             `RecordingStatusCallback`
     * @param string $conferenceRecordingStatusCallbackEvent Set which conference
     *                                                       recording state
     *                                                       changes should webhook
     *                                                       to the
     *                                                       `ConferenceRecordingStatusCallback`
     * @return CreateParticipantOptions Options builder
     */
    public static function create($statusCallback = Values::NONE, $statusCallbackMethod = Values::NONE, $statusCallbackEvent = Values::NONE, $timeout = Values::NONE, $record = Values::NONE, $muted = Values::NONE, $beep = Values::NONE, $startConferenceOnEnter = Values::NONE, $endConferenceOnExit = Values::NONE, $waitUrl = Values::NONE, $waitMethod = Values::NONE, $earlyMedia = Values::NONE, $maxParticipants = Values::NONE, $conferenceRecord = Values::NONE, $conferenceTrim = Values::NONE, $conferenceStatusCallback = Values::NONE, $conferenceStatusCallbackMethod = Values::NONE, $conferenceStatusCallbackEvent = Values::NONE, $recordingChannels = Values::NONE, $recordingStatusCallback = Values::NONE, $recordingStatusCallbackMethod = Values::NONE, $sipAuthUsername = Values::NONE, $sipAuthPassword = Values::NONE, $region = Values::NONE, $conferenceRecordingStatusCallback = Values::NONE, $conferenceRecordingStatusCallbackMethod = Values::NONE, $recordingStatusCallbackEvent = Values::NONE, $conferenceRecordingStatusCallbackEvent = Values::NONE) {
        return new CreateParticipantOptions($statusCallback, $statusCallbackMethod, $statusCallbackEvent, $timeout, $record, $muted, $beep, $startConferenceOnEnter, $endConferenceOnExit, $waitUrl, $waitMethod, $earlyMedia, $maxParticipants, $conferenceRecord, $conferenceTrim, $conferenceStatusCallback, $conferenceStatusCallbackMethod, $conferenceStatusCallbackEvent, $recordingChannels, $recordingStatusCallback, $recordingStatusCallbackMethod, $sipAuthUsername, $sipAuthPassword, $region, $conferenceRecordingStatusCallback, $conferenceRecordingStatusCallbackMethod, $recordingStatusCallbackEvent, $conferenceRecordingStatusCallbackEvent);
    }

    /**
     * @param boolean $muted Filter by muted participants
     * @param boolean $hold Only show participants that are held or unheld.
     * @return ReadParticipantOptions Options builder
     */
    public static function read($muted = Values::NONE, $hold = Values::NONE) {
        return new ReadParticipantOptions($muted, $hold);
    }
}

class UpdateParticipantOptions extends Options {
    /**
     * @param boolean $muted Indicates if the participant should be muted
     * @param boolean $hold Specifying true will hold the participant, while false
     *                      will un-hold.
     * @param string $holdUrl The 'HoldUrl' attribute lets you specify a URL for
     *                        music that plays when a participant is held.
     * @param string $holdMethod Specify GET or POST, defaults to GET
     * @param string $announceUrl The 'AnnounceUrl' attribute lets you specify a
     *                            URL for announcing something to the participant.
     * @param string $announceMethod Specify GET or POST, defaults to POST
     */
    public function __construct($muted = Values::NONE, $hold = Values::NONE, $holdUrl = Values::NONE, $holdMethod = Values::NONE, $announceUrl = Values::NONE, $announceMethod = Values::NONE) {
        $this->options['muted'] = $muted;
        $this->options['hold'] = $hold;
        $this->options['holdUrl'] = $holdUrl;
        $this->options['holdMethod'] = $holdMethod;
        $this->options['announceUrl'] = $announceUrl;
        $this->options['announceMethod'] = $announceMethod;
    }

    /**
     * Specifying `true` will mute the participant, while `false` will un-mute. Anything other than `true` or `false` is interpreted as `false`.
     * 
     * @param boolean $muted Indicates if the participant should be muted
     * @return $this Fluent Builder
     */
    public function setMuted($muted) {
        $this->options['muted'] = $muted;
        return $this;
    }

    /**
     * Specifying `true` will hold the participant, while `false` will remove them from hold.
     * 
     * @param boolean $hold Specifying true will hold the participant, while false
     *                      will un-hold.
     * @return $this Fluent Builder
     */
    public function setHold($hold) {
        $this->options['hold'] = $hold;
        return $this;
    }

    /**
     * The 'HoldUrl' attribute lets you specify a URL for music that plays when a participant is on hold. The URL may be an MP3, a WAV or a TwiML document that uses `<Play>`, `<Say>` or `<Redirect>`.
     * 
     * @param string $holdUrl The 'HoldUrl' attribute lets you specify a URL for
     *                        music that plays when a participant is held.
     * @return $this Fluent Builder
     */
    public function setHoldUrl($holdUrl) {
        $this->options['holdUrl'] = $holdUrl;
        return $this;
    }

    /**
     * Specify the HTTP method Twilio should use to request your `HoldUrl`, either `GET` or `POST`. Defaults to `GET`.
     * 
     * @param string $holdMethod Specify GET or POST, defaults to GET
     * @return $this Fluent Builder
     */
    public function setHoldMethod($holdMethod) {
        $this->options['holdMethod'] = $holdMethod;
        return $this;
    }

    /**
     * The 'AnnounceUrl' attribute lets you specify a URL for announcing something to the participant. The URL may return an MP3, a WAV or a TwiML document with `<Play>` or `<Say>`.
     * 
     * @param string $announceUrl The 'AnnounceUrl' attribute lets you specify a
     *                            URL for announcing something to the participant.
     * @return $this Fluent Builder
     */
    public function setAnnounceUrl($announceUrl) {
        $this->options['announceUrl'] = $announceUrl;
        return $this;
    }

    /**
     * Specify the HTTP method Twilio should use to request your `AnnounceUrl`, either `GET` or `POST`. Defaults to `POST`.
     * 
     * @param string $announceMethod Specify GET or POST, defaults to POST
     * @return $this Fluent Builder
     */
    public function setAnnounceMethod($announceMethod) {
        $this->options['announceMethod'] = $announceMethod;
        return $this;
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Api.V2010.UpdateParticipantOptions ' . implode(' ', $options) . ']';
    }
}

class CreateParticipantOptions extends Options {
    /**
     * @param string $statusCallback URL for conference event callback.
     * @param string $statusCallbackMethod Method Twilio should use to reach the
     *                                     status callback URL.
     * @param string $statusCallbackEvent Set state change events that will trigger
     *                                    a callback.
     * @param integer $timeout Number of seconds Twilio will wait for an answer.
     * @param boolean $record Record the agent and their conferences.
     * @param boolean $muted Mute the agent.
     * @param string $beep Play a beep when the participant joins the conference.
     * @param boolean $startConferenceOnEnter Begin the conference when the
     *                                        participant joins.
     * @param boolean $endConferenceOnExit End the conference when the participant
     *                                     leaves.
     * @param string $waitUrl URL that hosts pre-conference hold music
     * @param string $waitMethod The method Twilio should use to request `WaitUrl`.
     * @param boolean $earlyMedia Agents can hear the state of the outbound call.
     * @param integer $maxParticipants Maximum number of agent conference
     *                                 participants.
     * @param string $conferenceRecord Record the conference.
     * @param string $conferenceTrim Trim silence from audio files.
     * @param string $conferenceStatusCallback Callback URL for conference events.
     * @param string $conferenceStatusCallbackMethod HTTP method for requesting
     *                                               `ConferenceStatusCallback` URL.
     * @param string $conferenceStatusCallbackEvent Set which conference state
     *                                              changes should webhook to the
     *                                              `ConferenceStatusCallback`
     * @param string $recordingChannels Specify `mono` or `dual` recording channels.
     * @param string $recordingStatusCallback The absolute URL for Twilio's webhook
     *                                        with recording status information.
     * @param string $recordingStatusCallbackMethod HTTP method for
     *                                              `RecordingStatusCallback`
     * @param string $sipAuthUsername SIP username used for authenticating.
     * @param string $sipAuthPassword SIP password for authentication.
     * @param string $region The region where Twilio should mix the conference
     *                       audio.
     * @param string $conferenceRecordingStatusCallback Conference recording
     *                                                  callback URL.
     * @param string $conferenceRecordingStatusCallbackMethod Method Twilio should
     *                                                        use to request the
     *                                                        `ConferenceRecordingStatusCallback` URL.
     * @param string $recordingStatusCallbackEvent Set which recording state
     *                                             changes should webhook to the
     *                                             `RecordingStatusCallback`
     * @param string $conferenceRecordingStatusCallbackEvent Set which conference
     *                                                       recording state
     *                                                       changes should webhook
     *                                                       to the
     *                                                       `ConferenceRecordingStatusCallback`
     */
    public function __construct($statusCallback = Values::NONE, $statusCallbackMethod = Values::NONE, $statusCallbackEvent = Values::NONE, $timeout = Values::NONE, $record = Values::NONE, $muted = Values::NONE, $beep = Values::NONE, $startConferenceOnEnter = Values::NONE, $endConferenceOnExit = Values::NONE, $waitUrl = Values::NONE, $waitMethod = Values::NONE, $earlyMedia = Values::NONE, $maxParticipants = Values::NONE, $conferenceRecord = Values::NONE, $conferenceTrim = Values::NONE, $conferenceStatusCallback = Values::NONE, $conferenceStatusCallbackMethod = Values::NONE, $conferenceStatusCallbackEvent = Values::NONE, $recordingChannels = Values::NONE, $recordingStatusCallback = Values::NONE, $recordingStatusCallbackMethod = Values::NONE, $sipAuthUsername = Values::NONE, $sipAuthPassword = Values::NONE, $region = Values::NONE, $conferenceRecordingStatusCallback = Values::NONE, $conferenceRecordingStatusCallbackMethod = Values::NONE, $recordingStatusCallbackEvent = Values::NONE, $conferenceRecordingStatusCallbackEvent = Values::NONE) {
        $this->options['statusCallback'] = $statusCallback;
        $this->options['statusCallbackMethod'] = $statusCallbackMethod;
        $this->options['statusCallbackEvent'] = $statusCallbackEvent;
        $this->options['timeout'] = $timeout;
        $this->options['record'] = $record;
        $this->options['muted'] = $muted;
        $this->options['beep'] = $beep;
        $this->options['startConferenceOnEnter'] = $startConferenceOnEnter;
        $this->options['endConferenceOnExit'] = $endConferenceOnExit;
        $this->options['waitUrl'] = $waitUrl;
        $this->options['waitMethod'] = $waitMethod;
        $this->options['earlyMedia'] = $earlyMedia;
        $this->options['maxParticipants'] = $maxParticipants;
        $this->options['conferenceRecord'] = $conferenceRecord;
        $this->options['conferenceTrim'] = $conferenceTrim;
        $this->options['conferenceStatusCallback'] = $conferenceStatusCallback;
        $this->options['conferenceStatusCallbackMethod'] = $conferenceStatusCallbackMethod;
        $this->options['conferenceStatusCallbackEvent'] = $conferenceStatusCallbackEvent;
        $this->options['recordingChannels'] = $recordingChannels;
        $this->options['recordingStatusCallback'] = $recordingStatusCallback;
        $this->options['recordingStatusCallbackMethod'] = $recordingStatusCallbackMethod;
        $this->options['sipAuthUsername'] = $sipAuthUsername;
        $this->options['sipAuthPassword'] = $sipAuthPassword;
        $this->options['region'] = $region;
        $this->options['conferenceRecordingStatusCallback'] = $conferenceRecordingStatusCallback;
        $this->options['conferenceRecordingStatusCallbackMethod'] = $conferenceRecordingStatusCallbackMethod;
        $this->options['recordingStatusCallbackEvent'] = $recordingStatusCallbackEvent;
        $this->options['conferenceRecordingStatusCallbackEvent'] = $conferenceRecordingStatusCallbackEvent;
    }

    /**
     * The absolute URL where Twilio should send a webhook with conference event information that you request with the `StatusCallbackEvent` parameter.
     * 
     * @param string $statusCallback URL for conference event callback.
     * @return $this Fluent Builder
     */
    public function setStatusCallback($statusCallback) {
        $this->options['statusCallback'] = $statusCallback;
        return $this;
    }

    /**
     * The method Twilio should use when requesting your `StatusCallback` URL. Options are `GET` and `POST`. Defaults to `POST`.
     * 
     * @param string $statusCallbackMethod Method Twilio should use to reach the
     *                                     status callback URL.
     * @return $this Fluent Builder
     */
    public function setStatusCallbackMethod($statusCallbackMethod) {
        $this->options['statusCallbackMethod'] = $statusCallbackMethod;
        return $this;
    }

    /**
     * Specifies which conference state changes should generate a webhook to the `StatusCallback` URL. Options are `initiated`, `ringing`, `answered`, and `completed`. To specify multiple values, separate each with a space. Defaults to `completed`.
     * 
     * @param string $statusCallbackEvent Set state change events that will trigger
     *                                    a callback.
     * @return $this Fluent Builder
     */
    public function setStatusCallbackEvent($statusCallbackEvent) {
        $this->options['statusCallbackEvent'] = $statusCallbackEvent;
        return $this;
    }

    /**
     * The number of seconds (integer) that Twilio should allow the phone to ring before assuming there is no answer. Defaults to 60 seconds. Minimum allowed timeout is `5`, max is `600`. Twilio always adds a 5-second timeout buffer to outgoing calls, so if you enter a timeout value of 10 seconds, you will see an actual timeout closer to 15 seconds.
     * 
     * @param integer $timeout Number of seconds Twilio will wait for an answer.
     * @return $this Fluent Builder
     */
    public function setTimeout($timeout) {
        $this->options['timeout'] = $timeout;
        return $this;
    }

    /**
     * Records the agent and their conferences, including downtime between conferences. Values may be `true` or `false`. Defaults to `false`.
     * 
     * @param boolean $record Record the agent and their conferences.
     * @return $this Fluent Builder
     */
    public function setRecord($record) {
        $this->options['record'] = $record;
        return $this;
    }

    /**
     * Specify whether the agent can speak in the conference. Values can be `true` or `false`. Defaults to `false`.
     * 
     * @param boolean $muted Mute the agent.
     * @return $this Fluent Builder
     */
    public function setMuted($muted) {
        $this->options['muted'] = $muted;
        return $this;
    }

    /**
     * Play a notification beep to the conference when this participant joins. Options are `true`, `false`, `onEnter`, or `onExit`. Defaults to `true`.
     * 
     * @param string $beep Play a beep when the participant joins the conference.
     * @return $this Fluent Builder
     */
    public function setBeep($beep) {
        $this->options['beep'] = $beep;
        return $this;
    }

    /**
     * If the conference has not already begun, `true` will start the conference when this participant joins. Specifying `false` will mute the participant and play background music until the conference begins. Defaults to `true`.
     * 
     * @param boolean $startConferenceOnEnter Begin the conference when the
     *                                        participant joins.
     * @return $this Fluent Builder
     */
    public function setStartConferenceOnEnter($startConferenceOnEnter) {
        $this->options['startConferenceOnEnter'] = $startConferenceOnEnter;
        return $this;
    }

    /**
     * If `true`, will end the conference when this participant leaves. Defaults to `false`.
     * 
     * @param boolean $endConferenceOnExit End the conference when the participant
     *                                     leaves.
     * @return $this Fluent Builder
     */
    public function setEndConferenceOnExit($endConferenceOnExit) {
        $this->options['endConferenceOnExit'] = $endConferenceOnExit;
        return $this;
    }

    /**
     * Specify an absolute URL that hosts music to play before the  conference starts. Defualts to Twilio's standard [hold music](https://www.twilio.com/labs/twimlets/holdmusic).
     * 
     * @param string $waitUrl URL that hosts pre-conference hold music
     * @return $this Fluent Builder
     */
    public function setWaitUrl($waitUrl) {
        $this->options['waitUrl'] = $waitUrl;
        return $this;
    }

    /**
     * Specify which method, `GET` or `POST`, Twilio should use to request the `WaitUrl` for this conference. Be sure to use `GET` if you are directly requesting static audio files so that Twilio properly caches the files. Defaults to `POST`.
     * 
     * @param string $waitMethod The method Twilio should use to request `WaitUrl`.
     * @return $this Fluent Builder
     */
    public function setWaitMethod($waitMethod) {
        $this->options['waitMethod'] = $waitMethod;
        return $this;
    }

    /**
     * Allow an agent to hear the state of the outbound call, including ringing or disconnect messages. Can be `true` or `false`. Defaults to `true`.
     * 
     * @param boolean $earlyMedia Agents can hear the state of the outbound call.
     * @return $this Fluent Builder
     */
    public function setEarlyMedia($earlyMedia) {
        $this->options['earlyMedia'] = $earlyMedia;
        return $this;
    }

    /**
     * The maximum number of participants within this agent conference. Values can be positive integers from `2`-`10`. Defaults to `10`.
     * 
     * @param integer $maxParticipants Maximum number of agent conference
     *                                 participants.
     * @return $this Fluent Builder
     */
    public function setMaxParticipants($maxParticipants) {
        $this->options['maxParticipants'] = $maxParticipants;
        return $this;
    }

    /**
     * Records the conference that this participant is joining. Options are `true`, `false`, `record-from-start`, and `do-not-record`. Deafults to `false`
     * 
     * @param string $conferenceRecord Record the conference.
     * @return $this Fluent Builder
     */
    public function setConferenceRecord($conferenceRecord) {
        $this->options['conferenceRecord'] = $conferenceRecord;
        return $this;
    }

    /**
     * Specify whether to trim leading and trailing silence from your recorded conference audio files. Options are `trim-silence` and `do-not-trim`. Defaults to `trim-silence`
     * 
     * @param string $conferenceTrim Trim silence from audio files.
     * @return $this Fluent Builder
     */
    public function setConferenceTrim($conferenceTrim) {
        $this->options['conferenceTrim'] = $conferenceTrim;
        return $this;
    }

    /**
     * The absolute URL Twilio should request with conference events specified in `ConferenceStatusCallbackEvent`. This value is set by the first Participant to join the conference, and subsequent callback URLs will be ignored.
     * 
     * @param string $conferenceStatusCallback Callback URL for conference events.
     * @return $this Fluent Builder
     */
    public function setConferenceStatusCallback($conferenceStatusCallback) {
        $this->options['conferenceStatusCallback'] = $conferenceStatusCallback;
        return $this;
    }

    /**
     * The HTTP method Twilio should use when requesting the `ConferenceStatusCallback` URL. Either `GET` or `POST`. Defaults to `POST`.
     * 
     * @param string $conferenceStatusCallbackMethod HTTP method for requesting
     *                                               `ConferenceStatusCallback` URL.
     * @return $this Fluent Builder
     */
    public function setConferenceStatusCallbackMethod($conferenceStatusCallbackMethod) {
        $this->options['conferenceStatusCallbackMethod'] = $conferenceStatusCallbackMethod;
        return $this;
    }

    /**
     * Specifies which conference state changes should generate a webhook to the URL specified in the `ConferenceStatusCallback` attribute. Available values are `start`, `end`, `join`, `leave`, `mute`, `hold`, and `speaker`. To specify multiple values, separate them with a space. Defaults to `start` and `end`.
     * 
     * @param string $conferenceStatusCallbackEvent Set which conference state
     *                                              changes should webhook to the
     *                                              `ConferenceStatusCallback`
     * @return $this Fluent Builder
     */
    public function setConferenceStatusCallbackEvent($conferenceStatusCallbackEvent) {
        $this->options['conferenceStatusCallbackEvent'] = $conferenceStatusCallbackEvent;
        return $this;
    }

    /**
     * Set the recording channels for the final agent/conference recording. Either `mono` or `dual`. Defaults to `mono`.
     * 
     * @param string $recordingChannels Specify `mono` or `dual` recording channels.
     * @return $this Fluent Builder
     */
    public function setRecordingChannels($recordingChannels) {
        $this->options['recordingChannels'] = $recordingChannels;
        return $this;
    }

    /**
     * Specifies the `absolute URL` that Twilio should request when the recording is available if the agent and conference are recorded.
     * 
     * @param string $recordingStatusCallback The absolute URL for Twilio's webhook
     *                                        with recording status information.
     * @return $this Fluent Builder
     */
    public function setRecordingStatusCallback($recordingStatusCallback) {
        $this->options['recordingStatusCallback'] = $recordingStatusCallback;
        return $this;
    }

    /**
     * The HTTP method Twilio should use when requesting the `RecordingStatusCallback`. `GET` or `POST`. Defaults to `POST`.
     * 
     * @param string $recordingStatusCallbackMethod HTTP method for
     *                                              `RecordingStatusCallback`
     * @return $this Fluent Builder
     */
    public function setRecordingStatusCallbackMethod($recordingStatusCallbackMethod) {
        $this->options['recordingStatusCallbackMethod'] = $recordingStatusCallbackMethod;
        return $this;
    }

    /**
     * SIP username used for authenticating.
     * 
     * @param string $sipAuthUsername SIP username used for authenticating.
     * @return $this Fluent Builder
     */
    public function setSipAuthUsername($sipAuthUsername) {
        $this->options['sipAuthUsername'] = $sipAuthUsername;
        return $this;
    }

    /**
     * SIP password for authentication.
     * 
     * @param string $sipAuthPassword SIP password for authentication.
     * @return $this Fluent Builder
     */
    public function setSipAuthPassword($sipAuthPassword) {
        $this->options['sipAuthPassword'] = $sipAuthPassword;
        return $this;
    }

    /**
     * Specifies the [region](https://support.twilio.com/hc/en-us/articles/223132167-How-global-low-latency-routing-and-region-selection-work-for-conferences-and-Client-calls) where Twilio should mix the recorded audio. Options are `us1`, `ie1`, `de1`, `sg1`, `br1`, `au1`, `jp1`.
     * 
     * @param string $region The region where Twilio should mix the conference
     *                       audio.
     * @return $this Fluent Builder
     */
    public function setRegion($region) {
        $this->options['region'] = $region;
        return $this;
    }

    /**
     * The `absolute URL` Twilio should request when the conference recording is available.
     * 
     * @param string $conferenceRecordingStatusCallback Conference recording
     *                                                  callback URL.
     * @return $this Fluent Builder
     */
    public function setConferenceRecordingStatusCallback($conferenceRecordingStatusCallback) {
        $this->options['conferenceRecordingStatusCallback'] = $conferenceRecordingStatusCallback;
        return $this;
    }

    /**
     * The HTTP method Twilio should use when requesting your recording status callback URL, either `GET` or `POST`. Defaults to `POST`.
     * 
     * @param string $conferenceRecordingStatusCallbackMethod Method Twilio should
     *                                                        use to request the
     *                                                        `ConferenceRecordingStatusCallback` URL.
     * @return $this Fluent Builder
     */
    public function setConferenceRecordingStatusCallbackMethod($conferenceRecordingStatusCallbackMethod) {
        $this->options['conferenceRecordingStatusCallbackMethod'] = $conferenceRecordingStatusCallbackMethod;
        return $this;
    }

    /**
     * Specifies which recording state changes should generate a webhook to the URL specified in the `RecordingStatusCallback` attribute. Available values are `in-progress`, `completed`, `failed`. To specify multiple values, separate them with a space. Defaults to `in-progress`, `completed`, `failed`.
     * 
     * @param string $recordingStatusCallbackEvent Set which recording state
     *                                             changes should webhook to the
     *                                             `RecordingStatusCallback`
     * @return $this Fluent Builder
     */
    public function setRecordingStatusCallbackEvent($recordingStatusCallbackEvent) {
        $this->options['recordingStatusCallbackEvent'] = $recordingStatusCallbackEvent;
        return $this;
    }

    /**
     * Specifies which conference recording state changes should generate a webhook to the URL specified in the `ConferenceRecordingStatusCallback` attribute. Available values are `in-progress`, `completed`, `failed`. To specify multiple values, separate them with a space. Defaults to `in-progress`, `completed`, `failed`.
     * 
     * @param string $conferenceRecordingStatusCallbackEvent Set which conference
     *                                                       recording state
     *                                                       changes should webhook
     *                                                       to the
     *                                                       `ConferenceRecordingStatusCallback`
     * @return $this Fluent Builder
     */
    public function setConferenceRecordingStatusCallbackEvent($conferenceRecordingStatusCallbackEvent) {
        $this->options['conferenceRecordingStatusCallbackEvent'] = $conferenceRecordingStatusCallbackEvent;
        return $this;
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Api.V2010.CreateParticipantOptions ' . implode(' ', $options) . ']';
    }
}

class ReadParticipantOptions extends Options {
    /**
     * @param boolean $muted Filter by muted participants
     * @param boolean $hold Only show participants that are held or unheld.
     */
    public function __construct($muted = Values::NONE, $hold = Values::NONE) {
        $this->options['muted'] = $muted;
        $this->options['hold'] = $hold;
    }

    /**
     * Only return participants that are muted or unmuted. Either `true` or `false`.
     * 
     * @param boolean $muted Filter by muted participants
     * @return $this Fluent Builder
     */
    public function setMuted($muted) {
        $this->options['muted'] = $muted;
        return $this;
    }

    /**
     * Only return participants that are on hold or not on hold. Either `true` or `false`.
     * 
     * @param boolean $hold Only show participants that are held or unheld.
     * @return $this Fluent Builder
     */
    public function setHold($hold) {
        $this->options['hold'] = $hold;
        return $this;
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Api.V2010.ReadParticipantOptions ' . implode(' ', $options) . ']';
    }
}