<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Preview\Understand\Assistant\Intent;

use Twilio\InstanceContext;
use Twilio\Values;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
class IntentStatisticsContext extends InstanceContext {
    /**
     * Initialize the IntentStatisticsContext
     * 
     * @param \Twilio\Version $version Version that contains the resource
     * @param string $assistantSid The assistant_sid
     * @param string $intentSid The intent_sid
     * @return \Twilio\Rest\Preview\Understand\Assistant\Intent\IntentStatisticsContext 
     */
    public function __construct(Version $version, $assistantSid, $intentSid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = array('assistantSid' => $assistantSid, 'intentSid' => $intentSid, );

        $this->uri = '/Assistants/' . rawurlencode($assistantSid) . '/Intents/' . rawurlencode($intentSid) . '/Statistics';
    }

    /**
     * Fetch a IntentStatisticsInstance
     * 
     * @return IntentStatisticsInstance Fetched IntentStatisticsInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch() {
        $params = Values::of(array());

        $payload = $this->version->fetch(
            'GET',
            $this->uri,
            $params
        );

        return new IntentStatisticsInstance(
            $this->version,
            $payload,
            $this->solution['assistantSid'],
            $this->solution['intentSid']
        );
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $context = array();
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Preview.Understand.IntentStatisticsContext ' . implode(' ', $context) . ']';
    }
}