<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\FlexApi\V1\Interaction;

use Twilio\Http\Response;
use Twilio\Page;
use Twilio\Version;

class InteractionChannelPage extends Page {
    /**
     * @param Version $version Version that contains the resource
     * @param Response $response Response from the API
     * @param array $solution The context solution
     */
    public function __construct(Version $version, Response $response, array $solution) {
        parent::__construct($version, $response);

        // Path Solution
        $this->solution = $solution;
    }

    /**
     * @param array $payload Payload response from the API
     * @return InteractionChannelInstance \Twilio\Rest\FlexApi\V1\Interaction\InteractionChannelInstance
     */
    public function buildInstance(array $payload): InteractionChannelInstance {
        return new InteractionChannelInstance($this->version, $payload, $this->solution['interactionSid']);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        return '[Twilio.FlexApi.V1.InteractionChannelPage]';
    }
}